export type OrderItemType = {
  productid: string;
  price: number;
  count: number;
  selectedOptions?: {
    _id: string;
    title: string;
    value: number | string;
  }[];
};
export type FilteredOrderItemType = {
  productid: string;
  price: number;
  count: number;
  selectedOptions?: {
    title: string;
    value: number | string;
  }[];
};
export type OrderCardType = {
  count: number;
  price: number;
  productid: {
    images: string[];
    price: number;
    title: string;
    uid: string;
    _id: string;
  }[];
  _id: string;
};

export type orderType = {
  createdAt: string;
  price: number;
  products: OrderCardType[];
  uid: number;
  updatedAt: string;
  userid: string;

  _id: string;
};
