export type TicketFormData = {
  category: string;
  text: string;
  title: string;
  priority: string;
};

export type SendTicketData = {
  category: string;
  text: string;
  title: string;
  img: File | null | "";
};
export type SendTicketMessage = {
  ticketId: string;
  text: string;
  img: File | null | "";
};

export type TicketsType = {
  _id: string;
  uuid: number;
  title: string;
  userid: string;
  date: string;
  lastdate: string;
  category: string;
  status: "open" | "close";
};

export type TicketType = {
  _id: string;
  uuid: number;
  title: string;
  userid: string;
  date: string;
  lastdate: string;
  category: string;
  status: "open" | "close";
  masssge: {
    _id: string;
    text: string;
    time: string;
  }[];
  masssgeadmin: {
    _id: string;
    text: string;
    time: string;
  }[];
};

export type adminTickets = {
  category: string;
  date: string;
  lastdate: string;
  masssge: {
    _id: string;
    text: string;
    time: string;
  }[];
  masssgeadmin: {
    _id: string;
    text: string;
    time: string;
  }[];
  status: string;
  title: string;
  userid: string;
  _id: string;
};
