import AdminPanelLayout from "@/components/AdminLayout/AdminPanelLayout";
import AddBlogForm from "@/components/templates/adminPanel/blogs/newBlog/AddBlogForm";
import Link from "next/link";
import React from "react";

export default function page() {
  return (
    <AdminPanelLayout>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <div className="flex items-center justify-between">
            <p className="font-bold text-xl text-[#001A46] dark:text-light">
              وبلاگ
            </p>
            <Link
              className="inline-block flex-center h-11 px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-light rounded"
              href="/admin-panel/blogs/"
            >
              بازگشت
            </Link>
          </div>
          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="w-full overflow-x-auto scrollbar-custom">
          <AddBlogForm />
        </div>
      </section>
    </AdminPanelLayout>
  );
}
