import React from "react";
import Link from "next/link";
import AdminPanelLayout from "@/components/AdminLayout/AdminPanelLayout";
import DiscountForm from "@/components/templates/adminPanel/discounts/DiscountForm";

export default function NewDiscount() {
  return (
    <AdminPanelLayout>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div className="flex items-center justify-between">
          <div>
            <div className="flex items-center justify-between">
              <p className="font-bold text-xl text-[#001A46] dark:text-light">
                ایجاد کد تخفیف جدید
              </p>
            </div>
            <div className="flex items-center mt-4">
              <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
              <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
            </div>
          </div>
          <Link
            className="flex items-center gap-2.5 px-5 py-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 child:text-white rounded-md"
            href="/admin-panel/discounts"
          >
            <p>بازگشت</p>
            <svg className="size-4">
              <use href="#left-arrow"></use>
            </svg>
          </Link>
        </div>
        <DiscountForm />
      </section>
    </AdminPanelLayout>
  );
}
