"use client";
import React, {
  createContext,
  Dispatch,
  ReactNode,
  SetStateAction,
  useState,
} from "react";

type SidebarContextType = {
  isShowSidebar: boolean;
  setIsShowSidebar: Dispatch<SetStateAction<boolean>>;
};
export const SidebarContext = createContext<SidebarContextType | null>(null);

type ShowSidebarContextProps = {
  children: ReactNode;
};

export default function ShowSidebarContext({
  children,
}: ShowSidebarContextProps) {
  const [isShowSidebar, setIsShowSidebar] = useState<boolean>(false);
  return (
    <SidebarContext.Provider value={{ isShowSidebar, setIsShowSidebar }}>
      {children}
    </SidebarContext.Provider>
  );
}
