"use client";

import { getMe } from "@/services/auth";
import { useQuery } from "@tanstack/react-query";
import React, { createContext, ReactNode, useEffect, useState } from "react";

type userDate = {
  attempts: string;
  date: string;
  email: string;
  fname: string;
  isAuthentication: boolean;
  isflag: boolean;
  isdev: boolean;
  lname: string;
  otp: number;
  phone: string;
  role: "USER" | "ADMIN" | "SEO";
  status: "active" | "registering";
  username: string;
  invitation: number;
  refcode: number;
  wallet: number;
};
type userContextType = {
  userInfo: userDate | null;
  setUserInfo: React.Dispatch<React.SetStateAction<userDate | null>>;
  isLoading: boolean;
};

export const userContext = createContext<userContextType | null>(null);

export default function UserProvider({ children }: { children: ReactNode }) {
  const { data, isLoading, status } = useQuery({
    queryKey: ["get-me"],
    queryFn: getMe,
  });

  const [userInfo, setUserInfo] = useState<userDate | null>(null);

  useEffect(() => {
    if (typeof window !== "undefined") {
      const localData = localStorage.getItem("userInfo");
      setUserInfo(localData ? JSON.parse(localData) : null);
    }
  }, []);

  useEffect(() => {
    if (data) {
      setUserInfo(data.data.user);
      localStorage.setItem("userInfo", JSON.stringify(data.data.user));
    } else if (status === "error" || data === undefined) {
      localStorage.removeItem("userInfo");
      setUserInfo(null);
    }
  }, [data, status]);

  return (
    <userContext.Provider value={{ userInfo, setUserInfo, isLoading }}>
      {children}
    </userContext.Provider>
  );
}
