import Image from "next/image";
import React from "react";

export default function loading() {
  return (
    <div className="fixed top-0 right-0 flex items-center justify-center w-screen h-screen bg-neutral-800/60 backdrop-blur z-[999]">
      <div className="flex flex-col items-center justify-center w-[450px] h-[200px] mt-10 p-5 bg-light dark:bg-dark-500 text-center text-base rounded-9 border border-[#F2F2F2] dark:border-[#4E4E4E]">
        <Image
          src={"/images/darkobitLogo.svg"}
          width={150}
          height={150}
          alt="لوگو سایت دارکوبیت"
        />
        <p className="my-2 font-bold text-lg dark:text-light animate-pulse">
          لطفا صبر کنید ...
        </p>
      </div>
    </div>
  );
}
