import Link from "next/link";
import React from "react";

export default function notfound() {
  return (
    <main className="flex-center mt-20 mb-32">
      <section className="flex flex-col items-center justify-center gap-2 w-[350px] md:w-[400px] h-[200px] p-2.5 bg-light rounded-9 border border-light-500 shadow-lg">
        <svg className="size-10 text-secondary-default">
          <use href="#not-found"></use>
        </svg>
        <p className="text-lg font-peyda">متاسفانه صفحه مورد نظر یافت نشد</p>
        <Link
          href={"/"}
          className="px-2 py-3 mt-3 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-light  text-sm rounded-9"
        >
          بازگشت به صفحه اصلی سایت
        </Link>
      </section>
    </main>
  );
}
