import AddAuthBlog from "@/components/templates/userPanel/new-blog/AddAuthBlog";
import UserPanelLayout from "@/components/userLayout/UserPanelLayout";
import { cookies } from "next/headers";
import Link from "next/link";
import { redirect } from "next/navigation";
import React from "react";

export default async function page() {
  try {
    const token = cookies().get("accessToken")?.value;
    const res = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}user/profile`, {
      method: "GET",
      headers: {
        "Content-Type": "application/json",
        authorization: `Bearer ${token ? token : ""}`,
      },
    });
    const data = await res?.json();
    if (res?.ok !== true) {
      redirect("/");
    }
    if (data?.user?.role !== "SEO") {
      redirect("/");
    }
  } catch {
    redirect("/");
  }
  return (
    <UserPanelLayout>
      {" "}
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <div className="flex items-center justify-between">
            <p className="font-bold text-xl text-[#001A46] dark:text-light">
              وبلاگ
            </p>
            <Link
              className="inline-block flex-center h-11 px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-light rounded"
              href="/user-panel/blogs/"
            >
              بازگشت
            </Link>
          </div>
          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="w-full overflow-x-auto scrollbar-custom">
          <AddAuthBlog />
        </div>
      </section>
    </UserPanelLayout>
  );
}
