import { StatusType } from "@/@types/status";
import { BankNameFaHandler, getStatusLabel } from "@/lib/utils";
import Image from "next/image";
import React, { Dispatch, SetStateAction } from "react";

export default function BankInfoCard({
  id,
  number,
  icon,
  bank,
  status,
  setIsOpenBankDetailsMOdal,
  setBankId,
}: {
  id: string;
  number: string;
  icon: string;
  bank: string;
  status: StatusType;
  setIsOpenBankDetailsMOdal: Dispatch<SetStateAction<boolean>>;
  setBankId: Dispatch<SetStateAction<string>>;
}) {
  return (
    <div className="flex items-center gap-2.75 w-[377px] py-3 px-[18px]  bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
      <div>
        <Image
          src={`/images/banks/${icon}.svg`}
          width={48}
          height={48}
          alt="عکس بانک ملی"
          className="w-12 h-12"
        />
      </div>
      <div className="child:text-[#585858] dark:child:text-light">
        <p>{number}</p>
        <div className="flex items-center gap-2.5">
          <p className="mt-1">{BankNameFaHandler(bank)}</p>
          {status === "approved" && (
            <span className="p-1.5 bg-[#00B074]/10 text-xs-mines text-[#00B074] rounded-sm">
              {getStatusLabel(status)}
            </span>
          )}
          {status === "pending" && (
            <span className="p-1.5 bg-[#FF9D00]/10 text-xs-mines text-[#FF9D00] rounded-sm">
              {getStatusLabel(status)}
            </span>
          )}
          {status === "rejected" && (
            <span className="p-1.5 bg-[#FF0000]/10 text-xs-mines text-[#FF0000] rounded-sm">
              {getStatusLabel(status)}
            </span>
          )}
        </div>
      </div>
      <svg
        className="size-5 mr-auto text-[#8F8F8F] hover:text-dark dark:text-light duration-150 cursor-pointer"
        onClick={() => {
          setIsOpenBankDetailsMOdal(true);
          setBankId(id);
        }}
      >
        <use href="#ellipsis-horizontal"></use>
      </svg>
    </div>
  );
}
