import Link from "next/link";
import React from "react";

type ItemsType = {
  value: string;
  href: string;
};

type BreadcrumbProps = {
  items: ItemsType[];
};

export default function Breadcrumb({ items }: BreadcrumbProps) {
  return (
    <div className="flex items-center gap-3 child:text-dark/40 child:dark:text-light/40">
      <div className="flex items-center gap-x-3">
        <Link
          className="text-xs-mines sm:text-sm font-medium hover:text-dark/60 dark:hover:text-light/60 duration-150"
          href={"/"}
        >
          خانه
        </Link>
        <svg className="w-2 h-2">
          <use href="#chevron-left"></use>
        </svg>
      </div>
      {items?.map((item: ItemsType, index: number) => (
        <div key={item.value + item.href} className="flex items-center gap-x-3">
          <Link
            className={`${
              items.length - 1 === index
                ? "text-dark dark:text-light"
                : "hover:text-dark/60 dark:hover:text-light/60 duration-150"
            } text-xs-mines sm:text-sm font-medium`}
            href={item.href}
          >
            {item.value}
          </Link>
          {items.length - 1 !== index && (
            <svg className="w-2 h-2">
              <use href="#chevron-left"></use>
            </svg>
          )}
        </div>
      ))}
    </div>
  );
}
