import Image from "next/image";
import React from "react";

export default function DarkobitDesCard() {
  return (
    <div className="flex items-center gap-3 w-[387px] sm:w-[438px] px-4 py-2.75 sm:py-[19px] bg-light dark:bg-[#383838] rounded-xl overflow-hidden shadow-sm border border-[#E9E9E9] dark:border-[#4E4E4E]">
      <div className="w-[60px] sm:w-[69px] h-[60px] sm:h-[69px] shrink-0">
        <Image
          src={"/images/phone.svg"}
          width={69}
          height={69}
          alt="عکس توضیجات دارکوبیت"
          className="dark:hidden w-full h-full shrink-0"
        />
        <Image
          src={"/images/phone-dark.svg"}
          width={69}
          height={69}
          alt="عکس توضیجات دارکوبیت"
          className="hidden dark:inline-block w-full h-full shrink-0"
        />
      </div>
      <div>
        <p className="font-bold text-lg sm:text-xl text-neutral-900 dark:text-light">
          تقویت حافظه
        </p>
        <p className="mt-2.5 w-[267px] sm:w-[307px] text-[#717171] dark:tex-[#BABABA] text-sm-mines sm:text-base-mines">
          لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با
          استفاده از طراحان گرافیک است،
        </p>
      </div>
    </div>
  );
}
