import Image from "next/image";
import Link from "next/link";
import React from "react";

export default function DiscountBox({
  color,
  title,
  desc,
  textColor,
  link,
}: {
  color: string;
  title: string;
  desc: string;
  textColor: string;
  link: string;
}) {
  return (
    <div className={`${color} relative rounded-9 w-full h-[150px] p-5`}>
      <div className=" z-50">
        <div className={`${textColor} text-right`}>
          <p className="font-peyda font-bold text-2xl">{title}</p>
          <p className="mt-2 font-medium text-xs">{desc}</p>
        </div>
        <Link
          className="absolute bottom-1.25 right-3.75 inline-block py-1.25 px-3.75 mt-[28px] bg-light text-dark rounded !z-50"
          href={link}
        >
          مشاهده
        </Link>
      </div>
      <Image
        src={"/images/uPanel-discount-img.svg"}
        width={205}
        height={108}
        alt={title}
        className="absolute bottom-0 left-0 w-[205px] h-[108px]"
      />
      <Image
        src={"/images/uPanel-shape1.svg"}
        width={135}
        height={79}
        alt={title}
        className="absolute bottom-0 right-0 w-[135px] h-[79px]"
      />
      <Image
        src={"/images/uPanel-shape2.svg"}
        width={80}
        height={40}
        alt={title}
        className="absolute top-0 left-0 w-[80px] h-[40px]"
      />
    </div>
  );
}
