"use client";

import { usePathname } from "next/navigation";
import { useEffect, useState } from "react";
import Loading from "@/app/loading";

export default function GlobalLoadingHandler() {
  const pathname = usePathname();
  const [loading, setLoading] = useState(false);

  useEffect(() => {
    setLoading(true);
    const timeout = setTimeout(() => setLoading(false), 300);
    return () => clearTimeout(timeout);
  }, [pathname]);

  return loading ? <Loading /> : null;
}
