import { BlogType } from "@/@types/blog";
import Image from "next/image";
import Link from "next/link";
import React from "react";

type LatestBlogCardProps = {
  blogData: null | BlogType;
};

export const LatestBlogCard = ({ blogData }: LatestBlogCardProps) => {
  if (!blogData) return;

  return (
    <Link
      href={`/blogs/${blogData?.href}`}
      className="flex items-start gap-4 mb-5 w-[350px] md:w-[392px] p-6 rounded-40 border border-[#CFD2E3] dark:border-[#616161]"
    >
      <div className="w-[132px] h-[132px] overflow-hidden rounded-9 shrink-0">
        <Image
          src={`${process.env.NEXT_PUBLIC_BASE_URL}/${blogData?.img}`}
          alt="عکس وبلاگ"
          width={132}
          height={132}
          className="w-full h-full shrink-0"
        />
      </div>
      <div className="pt-2.25 pb-1.25">
        <p className="mt-2.5 my-[39px] text-base font-bold text-[#081035] dark:text-light line-clamp-1">
          {blogData?.title}
        </p>
        <div className="flex items-center gap-1 text-[#747893] dark:text-light">
          <svg className="size-5">
            <use href="#clock"></use>
          </svg>
          <p className="text-xs md:text-base">زمان مطالعه : 5 دقیقه</p>
        </div>
      </div>
    </Link>
  );
};
