"use client";
import React, { Dispatch, SetStateAction, useContext } from "react";

import { Button } from "@/components/ui/button";
import { logoutHandler } from "@/lib/token";
import CustomToast from "./CustomToast";
import { useRouter } from "next/navigation";
import { userContext } from "@/app/context/UserProvider";
import { OrderCountContext } from "@/app/context/OrderCountProvider";

type LogoutModalProps = {
  setIsOpenLogoutModal: Dispatch<SetStateAction<boolean>>;
};

export default function LogoutModal({
  setIsOpenLogoutModal,
}: LogoutModalProps) {
  const router = useRouter();
  const userInfo = useContext(userContext);
  const orderInfo = useContext(OrderCountContext);
  const clickHandler = () => {
    const logoutStatus = logoutHandler();
    if (logoutStatus) {
      router.replace("/");
      userInfo?.setUserInfo(null);
      orderInfo?.setLocalDate([]);
      orderInfo?.setOrderCount(0);
      CustomToast({
        type: "success",
        text: "با موفقیت از حساب کاربری خود خارج شدید",
      });
    }
  };
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-[899]">
      <div className="w-[350px] md:w-[400px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <p className="p-4 font-peyda font-bold text-lg  text-center">
            آیا می‌خواهید از حساب کاربری خود خارج شوید؟
          </p>
        </div>
        <div className="flex-center gap-2.5 w-full py-2">
          <Button
            className="inline-block flex-center h-10 px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-light hover:text-light rounded"
            variant="outline"
            onClick={() => {
              setIsOpenLogoutModal(false);
            }}
          >
            خیر
          </Button>
          <Button
            className="inline-block flex-center h-10 px-5 bg-red-600 hover:bg-red-500 text-base text-light rounded"
            onClick={clickHandler}
          >
            بله
          </Button>
        </div>
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpenLogoutModal(false);
        }}
      ></div>
    </div>
  );
}
