"use client";

import React, { Dispatch, SetStateAction } from "react";
import {
  Pagination,
  PaginationContent,
  PaginationDoubleNext,
  PaginationDoublePrevious,
  PaginationEllipsis,
  PaginationItem,
  PaginationLink,
  PaginationNext,
  PaginationPrevious,
} from "../ui/pagination";
import { paginationType } from "@/@types/pagination";

type PaginationContainerProps = {
  totalPages: number;
  page: number;
  setPage: Dispatch<SetStateAction<paginationType>>;
};

export default function PaginationContainer({
  totalPages,
  page,
  setPage,
}: PaginationContainerProps) {
  if (totalPages <= 1) return;

  const handlePageChange = (newPage: number) => {
    if (newPage >= 1 && newPage <= totalPages) {
      setPage((prev) => ({ ...prev, page: newPage }));
      scrollTo({ top: 0, behavior: "smooth" });
    }
  };

  return (
    <Pagination className="my-5">
      <PaginationContent>
        {/* Previous */}
        <PaginationItem>
          <PaginationDoublePrevious
            href={`#${page}`}
            onClick={(e) => {
              e.preventDefault();
              handlePageChange(page - 2);
            }}
            className="hover:bg-secondary-default hover:text-light"
          />
        </PaginationItem>
        <PaginationItem>
          <PaginationPrevious
            href={`#${page}`}
            onClick={(e) => {
              e.preventDefault();
              handlePageChange(page - 1);
            }}
            className="hover:bg-secondary-default hover:text-light"
          />
        </PaginationItem>

        {Array.from({ length: totalPages }, (_, i) => i + 1)
          .filter((p) => {
            return (
              p === 1 || p === totalPages || (p >= page - 1 && p <= page + 1)
            );
          })
          .map((p, idx, arr) => (
            <PaginationItem key={p} className="flex items-center">
              {idx > 0 && arr[idx] - arr[idx - 1] > 1 && <PaginationEllipsis />}

              <PaginationLink
                href={`#${page}`}
                isActive={p === page}
                onClick={(e) => {
                  e.preventDefault();
                  handlePageChange(p);
                }}
              >
                {p}
              </PaginationLink>
            </PaginationItem>
          ))}

        <PaginationItem>
          <PaginationNext
            href={`#${page}`}
            onClick={(e) => {
              e.preventDefault();
              handlePageChange(page + 1);
            }}
            className="hover:bg-secondary-default hover:text-light"
          />
        </PaginationItem>
        <PaginationItem>
          <PaginationDoubleNext
            href={`#${page}`}
            onClick={(e) => {
              e.preventDefault();
              handlePageChange(page + 2);
            }}
            className="hover:bg-secondary-default hover:text-light"
          />
        </PaginationItem>
      </PaginationContent>
    </Pagination>
  );
}
