import { file } from "@/@types/file";
import Image from "next/image";
import Link from "next/link";
import React from "react";

type ProductCardProps = {
  data: file;
};
export default function ProductCard({ data }: ProductCardProps) {
  return (
    <div className="px-6 py-[21px] bg-light dark:bg-[#393939] rounded-14 shadow-sm">
      <div className="">
        <div className=" flex-center w-[56px] py-1 mr-auto bg-[#6DA975]/20 dark:bg-[#DEDEDE]/20 rounded-18">
          <p className="flex-center w-[48px] py-1 bg-dark-800 dark:bg-[#666666] text-light font-peyda font-bold text-base rounded-14">
            30%
          </p>
        </div>
        <Link href={`/products/${data.title}/${data.uid}`}>
          <Image
            src={process.env.NEXT_PUBLIC_BASE_URL + data?.images[0]}
            alt={`عکس محصول ${data?.title}`}
            width={147}
            height={147}
            className="w-[147px] h-[147px] mt-2.75 mx-auto rounded-10"
          />
        </Link>
      </div>
      <Link href={`/products/${data.title}/${data.uid}`}>
        <p className="mt-6 font-peyda font-bold text-lg text-dark-800 dark:text-light">
          {data.title}
        </p>
      </Link>
      <div className="flex items-center gap-0.75 mt-2.25 text-[#FFA700]">
        <p className="font-peyda font-bold text-base">{data.Score}</p>
        <svg className="size-[15px] ">
          <use href="#star"></use>
        </svg>
      </div>
      <div className="flex items-center justify-between mt-4 w-full child:font-peyda child:text-[#081035]">
        <div className="flex-center p-2 lg:p-[13px] bg-light-200 dark:bg-light hover:bg-light-200/90 hover:dark:bg-light/80 duration-150 cursor-pointer rounded-9 lg:rounded-full">
          <Link href={`/products/${data.title}/${data.uid}`}>
            <svg className="size-[26px] text-[#081035] dark:text-dark">
              <use href="#shop"></use>
            </svg>
          </Link>
        </div>
        <div className="dark:text-[#EEEEEE]">
          <p className="font-peyda font-bold text-[#B2B4C2] text-base-mines line-through text-left">
            {data?.price?.toLocaleString()}{" "}
            <span className="font-peyda font-medium">تومان</span>
          </p>
          <p className="font-peyda font-bold text-lg">
            {data?.price?.toLocaleString()}{" "}
            <span className="font-peyda font-medium">تومان</span>
          </p>
        </div>
      </div>
    </div>
  );
}
