import React from "react";
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "../ui/accordion";

export default function QuestionsCard() {
  return (
    <Accordion
      type="single"
      collapsible
      className="w-[315px] xs:w-[387px] sm:w-[555px] px-[30px] py-[17px] bg-light dark:bg-[#383838] border border-[#F3F4FE] dark:border-[#4F4F4F] rounded-xl shadow-sm shrink-0"
    >
      <AccordionItem value="item-1" className="border-none">
        <AccordionTrigger className="font-medium text-base sm:text-xl text-[##F3F4FE]">
          مدت زمان مشاوره‌ها چقدر است؟
        </AccordionTrigger>
        <AccordionContent className="text-sm sm:text-base text-[#2D2D2D] dark:text-light">
          تماس از طرف مشتری انجام می‌شود و متخصص تعهدی جهت تماس با مشتری ندارد.
        </AccordionContent>
      </AccordionItem>
    </Accordion>
  );
}
