import Image from "next/image";
import React from "react";

type ReviewsCardProps = {
  // id: number;
  // job: string;
  name: string;
  text: string;
  icon: string;
  date: string;
};

export default function ReviewsCard({
  // id,
  // job,
  name,
  text,
  icon,
  date,
}: ReviewsCardProps) {
  return (
    <>
      <div className="flex items-center justify-start gap-2 w-full">
        <div className="size-[73px] rounded-full overflow-hidden">
          <Image
            src={`/images/profile/${icon}.png`}
            width={73}
            height={73}
            alt={` عکس مشتری ${name}`}
          />
        </div>
        <div>
          <p className="text-right text-base text-[#33323B] dark:text-light">
            {name}
          </p>
          <p className="mt-0.75 text-right text-base text-neutral-100">
            {new Date(date)?.toLocaleDateString("fa-ir")}
          </p>
        </div>
      </div>
      <p className="h-24 text-right text-base text-neutral-200 mt-[17px] overflow-hidden line-clamp-4">
        {text}
      </p>
      <div className="flex items-center justify-start gap-1 w-full mt-[46px]">
        <svg className="size-5 text-primary-200">
          <use href="#star"></use>
        </svg>
        <svg className="size-5 text-primary-200">
          <use href="#star"></use>
        </svg>
        <svg className="size-5 text-primary-200">
          <use href="#star"></use>
        </svg>
        <svg className="size-5 text-primary-200">
          <use href="#star"></use>
        </svg>
        <svg className="size-5 !text-[#EAE8F0]">
          <use href="#star"></use>
        </svg>
      </div>
    </>
  );
}
