import React, { Dispatch, SetStateAction } from "react";
import { Button } from "../ui/button";

export default function SettlementBox({
  isBtn,
  setIsOpen,
  value,
}: {
  isBtn: boolean;
  setIsOpen?: Dispatch<SetStateAction<boolean>>;
  value: string | number;
}) {
  return (
    <div
      className={`${
        isBtn
          ? "grow  py-3 px-[18px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md"
          : "grow  py-3 px-[18px]  bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md"
      }`}
    >
      <div>
        <p className="font-bold text-base text-[#404040]/70 dark:text-light">
          موجودی حساب
        </p>
        <div className="flex items-center mt-4">
          <span className="w-[20%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
          <span className="w-[80%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
        </div>
      </div>
      <div className="flex items-center justify-between gap-20 h-12 mt-[19px]">
        <div
          className={`flex items-center ${
            isBtn ? " gap-2" : "gap-[60px] w-full"
          } text-[#081035] dark:text-light`}
        >
          <p className="font-peyda font-extrabold text-base text-center">
            {value?.toLocaleString()}
          </p>
          <p className="w-full font-peyda font-medium text-base text-left">
            تومان
          </p>
        </div>
        {isBtn && setIsOpen && (
          <Button
            className="flex-center w-[129px] h-[48px] px-3 bg-[#E6F0FF] dark:bg-secondary-default hover:bg-secondary-default text-base font-medium text-secondary-default dark:text-light hover:text-light duration-150 rounded border border-[#B1D1FF] dark:border-secondary-default"
            variant={"outline"}
            onClick={() => setIsOpen(true)}
          >
            درخواست برداشت
          </Button>
        )}
      </div>
    </div>
  );
}
