import Link from "next/link";
import React from "react";

export default function TicketsDetailsCard({
  text,
  value,
  link,
}: {
  text: string;
  value: string;
  link: string;
}) {
  return (
    <div
      className={
        "flex items-center justify-between grow py-3 px-3.75  bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-10"
      }
    >
      <div className="flex items-center gap-x-1">
        <p className="text-[#454545] dark:text-light font-medium text-sm">
          {text}
        </p>
        <span className="font-bold text-lg text-secondary-default">
          {value}
        </span>
      </div>
      <Link href={link} className="mr-[30px]">
        <svg className="size-3.5 text-secondary-default">
          <use href="#chevron-left"></use>
        </svg>
      </Link>
    </div>
  );
}
