import Image from "next/image";
import Link from "next/link";
import React from "react";

export default function UserShopInfo({
  icon,
  title,
  value,
  price,
  url,
}: {
  icon: string;
  title: string;
  value?: string;
  price?: string;
  url?: string;
}) {
  return (
    <Link
      href={url ?? "/user-panel"}
      className="flex items-center gap-4 p-3 bg-light dark:bg-dark-500 rounded-md"
    >
      <div className="w-12 h-12 shrink-0">
        <Image
          className="w-full h-full"
          src={`/images/${icon}.png`}
          alt={title}
          width={50}
          height={50}
        />
      </div>
      <div className="w-full">
        <p className="text-[#6A6A6A] font-medium text-sm">{title}</p>
        <div className="flex items-center justify-between mt-2.5">
          <div className="font-extrabold text-xl text-[#464255] dark:text-light">
            {price ? (
              <p>
                {Number(price)?.toLocaleString()}{" "}
                <span className="text-[#6A6A6A] font-medium text-sm">
                  تومان
                </span>
              </p>
            ) : (
              value
            )}
          </div>
          <svg className="size-4 ml-2 text-[#3C3C3C] dark:text-light-200">
            <use href="#chevron-left"></use>
          </svg>
        </div>
      </div>
    </Link>
  );
}
