"use client";
import Image from "next/image";
import Link from "next/link";
import { usePathname } from "next/navigation";
import React from "react";
import FooterLatesBlogs from "../FooterLatesBlogs";

export const Footer = () => {
  const pathname = usePathname();
  if (
    pathname.startsWith("/user-panel") ||
    pathname.startsWith("/admin-panel")
  ) {
    return;
  }
  return (
    <footer>
      <section className="relative flex flex-wrap xl:flex-nowrap items-start lg:justify-center md:gap-5 xl:0 w-full px-[30px]  pt-[43px] pb-[80px] sm:pb-[105px] sm:pt-[62px] bg-success-300/[7%] dark:bg-dark-500 xl:px-[183px]">
        {/* about me */}
        <div className="lg:w-[200px] xl:w-[317px]">
          <div>
            <div>
              <Image
                src={"/images/logo-img.png"}
                width={215}
                height={53}
                alt="عکس لوگو سایت"
              />
            </div>
            <p className="mt-1.25">فروشگاه فایل و محصولات دیجیتال</p>
          </div>
          <p className="mt-9 font-light text-[#60515B] text-justify dark:text-light-200">
            دارکوبیت یک بازارچه آنلاین محصولات دانلودی است که در آن کاربران
            می‌توانند هر نوع محصول غیرفیزیکی مانند فایل‌های گرافیکی، آموزشی،
            نرم‌افزاری، قالب‌ها، پروژه‌ها، ابزارهای کاربردی و هر فایل دیجیتال
            دیگری را برای فروش قرار دهند و خریداران نیز بتوانند آن‌ها را به‌صورت
            فوری و امن دریافت کنند. مأموریت ما ایجاد فضایی ساده، سریع و قابل
            اعتماد برای خرید و فروش انواع فایل‌های دیجیتال است
          </p>
          <Link href={"/about-us"} className="flex items-end gap-3 mt-[45px]">
            <p className="text-base font-bold text-[#081035] dark:text-primary-200">
              درباره دارکوبیت
            </p>
            <svg className="w-3.5 h-4 text-[#081035] dark:text-primary-200">
              <use href="#left-arrow"></use>
            </svg>
          </Link>
        </div>
        <div className="flex items-end justify-between md:justify-normal gap-[35px] w-full md:w-auto">
          {/* links */}
          <div className="flex flex-col sm:flex-row items-start mt-[25px] md:mt-[53px] md:mr-[57px] ">
            {/* last blogs */}
            <FooterLatesBlogs />
            {/* easy access */}
            <div className="mt-9 sm:mt-0 md:mr-[51px]">
              <h4 className="font-bolds text-base-mines md:text-xl text-[#33323B] dark:text-light-200">
                دسترسی آسان
              </h4>
              <ul className="mt-[27px] child:mb-2.5">
                <li className="group flex items-center gap-4 child:text-neutral-200 child:dark:text-light text-xs md:text-base cursor-pointer">
                  <svg className="w-1.5 h-4 text-neutral-200">
                    <use href="#chevron-left"></use>
                  </svg>
                  <p className="text-xs md:text-base group-hover:text-primary-200">
                    <Link href={"/about-us"}>درباره ما</Link>
                  </p>
                </li>
                <li className="group flex items-center gap-4 child:text-neutral-200 child:dark:text-light cursor-pointer">
                  <svg className="w-1.5 h-4 text-neutral-200 group-hover:text-primary-200">
                    <use href="#chevron-left"></use>
                  </svg>
                  <p className="text-xs md:text-base group-hover:text-primary-200">
                    <Link href={"/contact-us"}>تماس با ما</Link>
                  </p>
                </li>
              </ul>
              <Link href={"/"} className="flex items-end gap-3 mt-[32px]">
                <p className="text-xs-mines md:text-base font-bold text-[#081035] dark:text-primary-200">
                  مشاهده همه کارشناسان
                </p>
                <svg className="w-2.5 md:w-3.5 h-3 md:h-4 text-[#081035] dark:text-primary-200">
                  <use href="#left-arrow"></use>
                </svg>
              </Link>
            </div>
          </div>
          {/* icons */}
          <div className="flex flex-col shrink-0 sm:mt-[25px] md:mt-[53px] md:mr-[37px] ml-2.5 md:ml-0">
            <a href="https://trustseal.enamad.ir/?id=664394&Code=pGqx3q4jfqLvDaJHA1q3tXvZ0TxyvcqI">
              <img
                src="https://trustseal.enamad.ir/logo.aspx?id=664394&Code=pGqx3q4jfqLvDaJHA1q3tXvZ0TxyvcqI"
                alt="Enamad Trust Seal"
                style={{ cursor: "pointer", width: 100, height: "auto" }}
              />
            </a>
          </div>
        </div>
        {/* to-section-footer */}
        <div className="absolute -top-11 left-0 w-full">
          <div className="flex items-center justify-between w-[350px] xs:w-[400px] md:w-[700px] lg:w-[964px] xl:w-[1050px] mx-auto  py-3.75 pl-2.5 lg:pl-3.75 pr-2.5 lg:pr-[37px] bg-[#FBFF00]/[30%] dark:bg-neutral-600 rounded-28">
            <p className="text-[#535160] dark:text-light font-bold text-small xs:text-xs-mines md:text-sm lg:text-base">
              دسترسی سریع به تخفیفات و خبرنامه‌های ویژه
            </p>
            <div className="flex items-center overflow-hidden sm:rounded-14">
              <input
                className="w-[100px] md:w-[180px] lg:w-[270px] h-[23px] md:h-[50px] pl-1.75 md:pl-3.75  bg-light dark:bg-[#808080] text-[#424242] dark:text-light text-small md:text-xs-mines lg:text-base outline-none"
                placeholder="example@gmail.com"
                type="text"
                dir="ltr"
              />
              <div className="flex-center gap-1 lg:gap-2.5 py-1.5 md:py-3 px-1 md:px-4 lg:px-8 lg:h-[50px] bg-[#3B3E3A] dark:bg-primary-200 text-light dark:text-dark-500  rounded-e-9">
                <svg className="size-1.75 md:size-4">
                  <use href="#email"></use>
                </svg>
                <p className="text-small md:text-sm lg:text-base">ثبت ایمیل</p>
              </div>
            </div>
          </div>
        </div>
        {/* bottom-section-footer */}
        <div className="absolute -bottom-11 left-0 w-full">
          <div className="flex items-center justify-between gap-0.5 md:gap-2 w-[350px] xs:w-[375px] md:w-[750px] lg:w-[964px] xl:w-[1050px] mx-auto  py-3.75 pl-2.5 lg:pl-3.75 pr-1 xs:pr-2.5 lg:pr-[37px]  child:bg-[#3B3E3A] child:rounded-20 child:text-light">
            <div className="hidden md:inline-flex items-center gap-2.5 lg:gap-[41px] w-[848px] py-5 pr-5">
              <div className="flex items-center gap-2.5 lg:gap-[35px] h-[30px]">
                <p className="text-xs lg:text-lg">تماس سریع</p>

                <Link
                  className="flex items-center gap-1 lg:gap-[15px]"
                  href="tel:0933456789"
                >
                  <span className="pt-1 text-xs xl:text-base whitespace-nowrap">
                    0933 456 789
                  </span>
                  <svg className="size-5 ">
                    <use href="#phone"></use>
                  </svg>
                </Link>
              </div>
              <div className="text-light flex items-center gap-2.5 h-[30px]">
                <svg className="size-5">
                  <use href="#location"></use>
                </svg>
                <p className="text-sm xl:text-base">
                  تهران، مینی سیتی، شهرک صدف، مجتمع آسمان
                </p>
              </div>
            </div>
            <div className="md:hidden">
              <Link
                className="flex items-center py-[17px] px-[38px] xs:[150px] xs:w-[191px] h-[65px] grow text-sm xs:text-base whitespace-nowrap"
                href="tel:0933456789"
              >
                0933 456 789
              </Link>
            </div>
            <div className="flex items-center gap-[39px] w-[189px] py-auto px-[23px]  h-[65px] md:h-[69px]">
              <Link href={"https://t.me/darkoobit"} target="_blank">
                <svg className="size-5 text-light">
                  <use href="#telegram"></use>
                </svg>
              </Link>
              <Link href={"https://t.me/darkoobit"} target="_blank">
                <svg className="size-5 text-light">
                  <use href="#whatsapp"></use>
                </svg>
              </Link>
              <Link
                href={"https://www.instagram.com/darkoobit"}
                target="_blank"
              >
                <svg className="size-5 text-light">
                  <use href="#instagram"></use>
                </svg>
              </Link>
            </div>
          </div>
        </div>
      </section>
      <section className="h-[120px] bg-[#F3F4FF]/50 dark:bg-dark-200 text-sm text-[#6F6C7C] dark:text-light text-center">
        <p className="pt-[58px] pb-[38px] px-[17px] text-center">
          © 1404 - 2025 | تمامی حقوق مادی وبسایت برای{" "}
          <span className="text-success-200 dark:text-primary-200 font-bold">
            وبسایت دارکوبیت
          </span>{" "}
          و صاحب آن محفوظ است. هرگونه کپی برداری، پیگرد قانونی خواهد داشت.
        </p>
      </section>
    </footer>
  );
};
