import Image from "next/image";
import React from "react";

export default function AboutMe() {
  return (
    <section className="relative w-full pt-11 mt-10 xl:mt-3.25 bg-light-200 dark:bg-dark-200">
      <div className="container flex flex-col xl:flex-row items-start justify-center xl:justify-start gap-[23px] xl:gap-[43px] mx-auto bg-light dark:bg-dark-300 rounded-33 pt-[26px] pr-2.25 lg:pr-28 pl-2.25 lg:pl-[67px]">
        <div className="mx-auto ">
          <div className="flex lg:hidden items-center justify-center gap-3.5">
            <span className="inline-block w-6 h-1 bg-secondary-default dark:bg-primary-200 rounded-lg"></span>
            <p className="font-bold text-2xl">درباره ما</p>
          </div>
          <div className="relative xl:mb-[30px] w-[347px] h-[379px] shrink-0 mx-auto">
            <Image
              className="absolute bottom-[81%] lg:bottom-0 -right-[59px]"
              src={"/images/aboutme-stars.svg"}
              width={84}
              height={89}
              alt="عکس ستاره"
            />
            <Image
              src={"/images/about-me.png"}
              width={347}
              height={379}
              alt="عکس درباره ما"
              className="w-full h-full shrink-0"
            />
          </div>
        </div>

        <div className="mt-[37px]">
          <div className="hidden lg:flex items-center gap-3.5">
            <span className="inline-block w-1 h-[37px] bg-secondary-default dark:bg-primary-200 rounded-lg"></span>
            <p className="font-bold text-2xl">درباره ما</p>
          </div>
          <div className="mt-[17px] px-[30px] text-justify text-base text-[#868686] dark:text-[#F3F3F3]">
            لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با
            استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در
            ستون لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با
            استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در
            ستون لورم چاپگرها و متون بلکه روزنامه و مجله در ستون لورمچاپگرها و
            متون بلکه روزنامه و مجله در ستون لورم چاپگرها و متون بلکه روزنامه و
            مجله در ستون لورم چاپگرها و متون بلکه روزنامه و مجله در ستون لورم
          </div>
          <div className="flex flex-col sm:flex-row md:items-end justify-center lg:justify-end mt-4 w-full sm:w-auto">
            <div className="pb-2 md:pb-[51px] ml-auto sm:ml-4">
              <svg className="inline-block w-[55px] md:w-[78px] h-[35px] md:h-[78px] ">
                <use href="#blue-arrow"></use>
              </svg>
            </div>
            <button className="w-full md:w-auto py-3.75 md:px-[42px] mb-10 bg-primary-200 hover:bg-primary-200/70 text-dark text-base font-bold duration-150 rounded-10">
              بیشتر بخوانید
            </button>
          </div>
        </div>
      </div>
      <div className="relative top-[111px] w-full md:w-[735px] lg:w-[966px] xl:w-[1031px] md:h-[207px] px-[23px] mx-auto mb-[201px]">
        <div className="relative pt-[23px] px-2 md:px-0 w-full h-full bg-[#1D6ADB] dark:bg-dark-500 rounded-24 overflow-hidden">
          <div className="flex items-center justify-center gap-7 mx-auto ">
            <span className="inline-block w-[49px] h-0.75 bg-[#FEE251]"></span>
            <p className="text-light text-2xl font-peyda font-bold">
              آمار و ارقام
            </p>
            <span className="inline-block w-[49px] h-0.75 bg-[#FEE251]"></span>
          </div>

          <div className="absolute -top-12 -right-16 -rotate-12 w-[369px] g-[333px]">
            <Image
              src={"/images/Pattern-aboutMe.svg"}
              width={369}
              height={333}
              alt="عکس پترن"
              className="w-full h-full"
            />
          </div>
          <div className="absolute bottom-0 md:bottom-0 md:-top-12 -left-28 rotate-[30deg] w-[369px] g-[333px]">
            <Image
              src={"/images/Pattern-aboutMe.svg"}
              width={369}
              height={333}
              alt="عکس پترن"
              className="w-full h-full"
            />
          </div>
          {/* des */}
          <div className="flex md:hidden flex-wrap items-center justify-center py-[43px] gap-9  lg:gap-[29px] child:w-[165px] lg:child:w-[199px] child:h-[185px] z-40">
            <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
              <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
                ۵۳۱+
              </p>
              <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
                تعداد محصولات
              </p>
            </div>
            <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
              <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
                ۱+
              </p>
              <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
                تعداد محصولات
              </p>
            </div>
            <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
              <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
                8۱+
              </p>
              <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
                تعداد محصولات
              </p>
            </div>
            <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
              <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
                ۳۱+
              </p>
              <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
                تعداد محصولات
              </p>
            </div>
          </div>
        </div>
        {/* des */}
        <div className="absolute top-[106px] right-[30px] lg:right-[38px] xl:right-[74px] hidden md:inline-flex flex-wrap md:flex-row items-center gap-1.5 lg:gap-[29px] child:w-[165px] lg:child:w-[199px] child:h-[185px] z-40">
          <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
            <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
              ۵۳۱+
            </p>
            <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
              تعداد محصولات
            </p>
          </div>
          <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
            <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
              ۱+
            </p>
            <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
              تعداد محصولات
            </p>
          </div>
          <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
            <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
              8۱+
            </p>
            <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
              تعداد محصولات
            </p>
          </div>
          <div className="pt-[34px] pb-7 bg-light dark:bg-dark-300 rounded-40 shadow">
            <p className="mx-14 font-bold text-3x-mines lg:text-4xl text-success-200 dark:text-light text-center">
              ۳۱+
            </p>
            <p className="pt-10 font-medium text-center text-dark-800 dark:text-light">
              تعداد محصولات
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
