"use client";
import { SidebarContext } from "@/app/context/ShowSidebarContext";
import Link from "next/link";
import { usePathname } from "next/navigation";
import React, { useContext } from "react";

export default function AdminPanelSidebarLinks() {
  const pathname = usePathname();
  const pathnameSplit = pathname?.split("/");
  const pageUrl = pathnameSplit[2] ? pathnameSplit[2] : "/";
  const showSidebarContext = useContext(SidebarContext);
  const closeSidebarHandler = () => {
    showSidebarContext?.setIsShowSidebar(false);
  };
  return (
    <ul className="h-[400px] md:h-auto px-[26px] my-6 space-y-2.25 overflow-y-auto ">
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "/home"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/"
        >
          <svg className="size-5 shrink-0">
            <use href="#home"></use>
          </svg>
          <p>صفحه اصلی</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "/"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel"
        >
          <svg className="size-5 shrink-0">
            <use href="#squares-2x2"></use>
          </svg>
          <p>داشبورد</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "userList"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/userList"
        >
          <svg className="size-5 shrink-0">
            <use href="#users"></use>
          </svg>
          <p>کاربران</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "categories"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/categories"
        >
          <svg className="size-5 shrink-0">
            <use href="#list-bullet"></use>
          </svg>
          <p>دسته بندی‌ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "withdrawal"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/withdrawal"
        >
          <svg className="size-5 shrink-0">
            <use href="#doc"></use>
          </svg>
          <p>لیست درخواست برداشت</p>
        </Link>
      </li>

      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "customers"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="#bookMark"
        >
          <svg className="size-5 shrink-0">
            <use href="#user"></use>
          </svg>
          <p>باشگاه مشتریان</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "files"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/files"
        >
          <svg className="size-5 shrink-0">
            <use href="#question"></use>
          </svg>
          <p>فایل‌ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "blogs"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/blogs"
        >
          <svg className="size-5 shrink-0">
            <use href="#document-text"></use>
          </svg>
          <p>وبلاگ</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "tickets"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/tickets"
        >
          <svg className="size-5 shrink-0">
            <use href="#chat-bubble-left-ellipsis"></use>
          </svg>
          <p>تیکت ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "notification"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/notification"
        >
          <svg className="size-5 shrink-0">
            <use href="#bell-outline"></use>
          </svg>
          <p>نوتفیکیشن ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "comments"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/comments"
        >
          <svg className="size-5 shrink-0">
            <use href="#chat-bubble-left-right"></use>
          </svg>
          <p>کامنت ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "contact-us"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/contact-us"
        >
          <svg className="size-5 shrink-0">
            <use href="#user-group"></use>
          </svg>
          <p>پیام کاربران</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "discounts"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/discounts"
        >
          <svg className="size-5 shrink-0">
            <use href="#ticket"></use>
          </svg>
          <p>کدتخفیف ها</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "banks"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/banks"
        >
          <svg className="size-5 shrink-0">
            <use href="#credit-card"></use>
          </svg>
          <p>حساب های بانک</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "developers"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/admin-panel/developers"
        >
          <svg className="size-5 shrink-0">
            <use href="#world"></use>
          </svg>
          <p>حساب توسعه دهنده‌ها</p>
        </Link>
      </li>
    </ul>
  );
}
