import { Button } from "@/components/ui/button";
import Image from "next/image";
import React, { Dispatch, SetStateAction } from "react";

type BannerModalProps = {
  setOpen: Dispatch<SetStateAction<boolean>>;
  imgSrc: string;
  storeTitle: string;
};

export default function BannerModal({
  setOpen,
  imgSrc,
  storeTitle,
}: BannerModalProps) {
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-50">
      <div className="w-[350px] md:w-[400px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <p className="font-bold text-base text-[#001A46] dark:text-light">
            بنر فروشگاه {storeTitle}
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[20%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[80%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>

        {imgSrc ? (
          <div className="w-full h-[400px]">
            <Image
              src={`${process.env.NEXT_PUBLIC_BASE_URL}${imgSrc}`}
              alt={storeTitle}
              width={1200}
              height={400}
              className="w-full h-full"
            />
          </div>
        ) : (
          <p className="w-full p-5 text-center text-error-400 text-base ">
            عکس بنر یافت شند
          </p>
        )}
        <div className="flex-center gap-2.5 w-full py-2">
          <Button
            className="inline-block flex-center h-10 px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-light hover:text-light rounded"
            variant="outline"
            onClick={() => {
              setOpen(false);
            }}
          >
            بستن
          </Button>
        </div>
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setOpen(false);
        }}
      ></div>
    </div>
  );
}
