"use client";

import React, { useState } from "react";
import { devDataType } from "@/@types/dev";
import { paginationType } from "@/@types/pagination";
import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { defaultPage } from "@/lib/constants";
import { getAdminDevList } from "@/services/dev";
import { useQuery } from "@tanstack/react-query";
import PaginationContainer from "@/components/modules/PaginationContainer";
import AdminDevStatusModal from "@/components/modules/AdminDevStatusModal";
import DevDeleteModal from "./DevDeleteModal";
import BannerModal from "./BannerModal";

export default function DeveloperTable() {
  // const queryClient = useQueryClient();

  const [paginationSize, setPaginationSize] =
    useState<paginationType>(defaultPage);

  const { data: devs, isLoading } = useQuery({
    queryKey: ["admin-dev", paginationSize.page],
    queryFn: () => getAdminDevList(paginationSize),
    select: (res) => res.data,
  });

  const [openUpdateStatusModal, setIsOpenUpdateStatusModal] =
    useState<boolean>(false);
  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [isShowBannerModal, setIsShowBannerModal] = useState<boolean>(false);
  const [devId, setDevId] = useState<string>("");
  const [imgSrc, setImgSrc] = useState<string>("");
  const [storeTitle, setStoreTitle] = useState<string>("");

  if (isLoading) return <LoadingBox />;
  const totalPages = Math.ceil(devs?.meta.total / devs?.meta.limit);
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عنوان
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              بیو
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              ایمیل
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              موبایل
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              وبسایت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              وضعیت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              مشاهده بنر
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تغییر وضعیت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {devs?.data.map((dev: devDataType) => (
            <tr
              key={dev._id}
              className=" child:py-[30px] child:px-2 child:text-right child:grow child:w-[175px]"
            >
              <td>
                <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm">
                  {dev.title}
                </p>
              </td>
              <td>
                <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm text-wrap break-all leading-6">
                  {dev.bio}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {dev.email}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {dev.phone}
                </p>
              </td>
              <td>
                <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                  {dev.website}
                </p>
              </td>
              <td className="child:text-center ">
                {dev.status === "approved" && (
                  <p className="text-[#00B074] text-sm text-center w-full">
                    تأیید شده
                  </p>
                )}
                {dev.status === "pending" && (
                  <p className="text-[#FF9D00] text-sm text-center w-full">
                    در انتظار تأیید
                  </p>
                )}
                {dev.status === "rejected" && (
                  <p className="text-[#FF0000] text-sm text-center w-full">
                    رد شده
                  </p>
                )}
              </td>
              <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  onClick={() => {
                    setIsShowBannerModal(true);
                    setImgSrc(dev?.banner);
                    setStoreTitle(dev?.title);
                  }}
                >
                  مشاهده
                </Button>
              </td>
              <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  onClick={() => {
                    setIsOpenUpdateStatusModal(true);
                    setDevId(dev._id);
                  }}
                >
                  تغییر
                </Button>
              </td>
              <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 text-white text-xs mx-auto rounded-md`}
                  onClick={() => {
                    setIsOpenDeleteModal(true);
                    setDevId(dev._id);
                  }}
                >
                  حذف
                </Button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>

      <PaginationContainer
        page={paginationSize.page}
        setPage={setPaginationSize}
        totalPages={totalPages}
      />

      {openUpdateStatusModal && (
        <AdminDevStatusModal
          setIsOpenUpdateStatusModal={setIsOpenUpdateStatusModal}
          devId={devId}
          page={paginationSize.page}
        />
      )}
      {isOpenDeleteModal && (
        <DevDeleteModal
          setIsOpenDeleteModal={setIsOpenDeleteModal}
          devId={devId}
          page={paginationSize.page}
        />
      )}
      {isShowBannerModal && (
        <BannerModal
          setOpen={setIsShowBannerModal}
          imgSrc={imgSrc}
          storeTitle={storeTitle}
        />
      )}
    </>
  );
}
