"use client";
import { discountType } from "@/@types/discount";
import { Button } from "@/components/ui/button";
import { getDiscounts } from "@/services/discount";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";
import DeleteModal from "./DeleteModal";
import LoadingBox from "@/components/modules/LoadingBox";
import DiscountUpdateModal from "./DiscountUpdateModal";

export default function DiscountTable() {
  const { data, isLoading } = useQuery({
    queryKey: ["admin-discounts"],
    queryFn: getDiscounts,
    select: (res) => res.data.data,
  });
  const [isOpenDeleteModal, setIsDeleteModal] = useState<boolean>(false);
  const [isOpenEditModal, setIsEditModal] = useState<boolean>(false);
  const [discountId, setDiscountId] = useState<string>("");
  const [discountData, setDiscountData] = useState<discountType | null>(null);

  if (isLoading) return <LoadingBox />;
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              درصد تخفیف
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              کد تخفیف
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ ایجاد
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ انقضا
            </th>

            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              کل / تعداد استفاده
            </th>
            {/* <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            حذف
          </th> */}
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        {data?.length > 0 && (
          <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
            {data?.map((discount: discountType) => (
              <tr
                key={discount._id}
                className=" child:py-[30px] child:px-2 child:text-right child:grow child:!w-10"
              >
                <td className="!w-[10px]">
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {discount.amount}
                  </p>
                </td>
                <td className="!w-[10px]">
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {discount.code}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {new Date(discount?.createdAt)?.toLocaleDateString("fa-IR")}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {new Date(discount?.expiry)?.toLocaleDateString("fa-IR")}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {discount?.usageLimit} / {discount?.usedCount}
                  </p>
                </td>

                {/* <td className="!max-w-[80px]">
                <Button
                  className={`flex-center  w-[70px] p-2.5  duration-150 text-white text-xs mx-auto rounded-md bg-[#FF0000] hover:bg--[#FF0000]/90`}
                  //   onClick={() => {
                  //     setFileId(file?._id);
                  //     setIsOpenDeleteModal(true);
                  //   }}
                >
                  حذف
                </Button>
              </td> */}

                <td className="!max-w-[80px]">
                  <div className="flex flex-row items-center">
                    <Button
                      className={`flex-center  w-[70px] p-2.5 bg-[#FF0000] hover:bg-[#FF0000]/80  duration-150 text-white text-xs mx-auto rounded-md `}
                      onClick={() => {
                        setIsDeleteModal(true);
                        setDiscountId(discount?._id);
                      }}
                    >
                      حذف
                    </Button>
                    <Button
                      className={`flex-center  w-[70px] p-2.5 bg-primary-700 hover:bg-primary-700/90  duration-150 text-white text-xs mx-auto rounded-md `}
                      onClick={() => {
                        setIsEditModal(true);
                        setDiscountData(discount);
                      }}
                    >
                      ویرایش
                    </Button>
                  </div>
                </td>
              </tr>
            ))}
          </tbody>
        )}
      </table>
      {isOpenDeleteModal && (
        <DeleteModal
          discountId={discountId}
          setIsOpenDeleteModal={setIsDeleteModal}
          keyValue="admin-discounts"
        />
      )}
      {isOpenEditModal && (
        <DiscountUpdateModal
          setIsOpen={setIsEditModal}
          discountData={discountData}
        />
      )}
    </>
  );
}
