"use client";
import { file } from "@/@types/file";
import LoadingBox from "@/components/modules/LoadingBox";
import NotFoundDataBox from "@/components/modules/NotFoundDataBox";
import { Button } from "@/components/ui/button";
import { getFiles } from "@/services/file";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";
import EditModal from "./EditModal";
import DeleteModal from "./DeleteModal";
import Image from "next/image";
import Link from "next/link";

export default function FilesTable() {
  const [fileId, setFileId] = useState<string>("");
  const [isOpenEditModal, setIsOpenEditModal] = useState<boolean>(false);
  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [fileDet, setFileDet] = useState<null | file>(null);

  const { data: files, isLoading } = useQuery({
    queryKey: ["admin-files"],
    queryFn: getFiles,
    select: (res) => res.data,
  });

  if (isLoading) return <LoadingBox />;
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عنوان
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              توضیحات
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              قیمت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              دسته بندی
            </th>

            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              وضعیت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              حذف
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        {files?.data.length > 0 && (
          <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
            {files?.data.map((file: file) => (
              <tr
                key={file._id}
                className=" child:py-[30px] child:px-2 child:text-right child:grow child:w-[175px]"
              >
                <td>
                  <Link
                    href={`/products/${file.title}/${file.uid}`}
                    className="flex items-center gap-1"
                  >
                    <Image
                      src={process.env.NEXT_PUBLIC_BASE_URL + file?.images[0]}
                      width={80}
                      height={80}
                      alt={file?.title}
                      className="rounded-9"
                    />
                    <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm">
                      {file.title}
                    </p>
                  </Link>
                </td>
                <td>
                  <p className="w-[175px] text-center text-[#575757] dark:text-light/80 text-sm text-wrap break-all leading-6 line-clamp-3">
                    {file.subdecs}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {file?.price.toLocaleString()}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {file?.categoryid}
                  </p>
                </td>

                <td className="child:text-center ">
                  {file.isaccept && (
                    <p className="text-[#00B074] text-sm text-center w-full">
                      فعال
                    </p>
                  )}
                  {/* {file.status === "pending" && (
                  <p className="text-[#FF9D00] text-sm text-center w-full">
                    در انتظار تأیید
                  </p>
                )} */}
                  {!file.isaccept && (
                    <p className="text-[#FF0000] text-sm text-center w-full">
                      غیر فعال
                    </p>
                  )}
                </td>

                <td className="!max-w-[80px]">
                  <Button
                    className={`flex-center  w-[70px] p-2.5  duration-150 text-white text-xs mx-auto rounded-md bg-[#FF0000] hover:bg--[#FF0000]/90`}
                    onClick={() => {
                      setFileId(file?._id);
                      setIsOpenDeleteModal(true);
                    }}
                  >
                    حذف
                  </Button>
                </td>

                <td className="!max-w-[80px]">
                  <Button
                    className={`flex-center  w-[70px] p-2.5 bg-primary-700 hover:bg-primary-700/90  duration-150 text-white text-xs mx-auto rounded-md `}
                    onClick={() => {
                      setIsOpenEditModal(true);
                      setFileDet(file);
                    }}
                  >
                    ویرایش
                  </Button>
                </td>
              </tr>
            ))}
          </tbody>
        )}
      </table>
      {files?.data.length === 0 && <NotFoundDataBox />}
      {isOpenEditModal && (
        <EditModal setIsOpenEditModal={setIsOpenEditModal} data={fileDet} />
      )}
      {isOpenDeleteModal && (
        <DeleteModal setIsOpenDeleteModal={setIsOpenDeleteModal} id={fileId} />
      )}
    </>
  );
}
