"use client";
import { NotificationType } from "@/@types/notificaton";
import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { getNotification } from "@/services/notification";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";
import ShowNotifyModal from "./ShowNotifyModal";
import DeleteModal from "./DeleteModal";
import EditNotificationModal from "./EditNotificationModal";

export default function NotifyTable() {
  const [isOpenShowModal, setIsOpenShowModal] = useState<boolean>(false);
  const [isOpenEditModal, setIsOpenEditModal] = useState<boolean>(false);
  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [notifyId, setNotifyId] = useState<string>("");
  const [notifyData, setNotifyData] = useState<null | NotificationType>(null);

  const { data: notification, isLoading } = useQuery({
    queryKey: ["admin-notify"],
    queryFn: getNotification,
    select: (res) => res.data,
  });

  if (isLoading) return <LoadingBox />;
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عنوان
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ ایجاد
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              وضعیت
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        {notification?.notifs?.length > 0 && (
          <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
            {notification?.notifs?.map((notify: NotificationType) => (
              <tr
                key={notify._id}
                className=" child:py-[30px] child:px-2 child:text-right child:grow child:!w-10"
              >
                <td className="!w-[10px]">
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm line-clamp-1">
                    {notify?.title}
                  </p>
                </td>
                <td className="!w-[10px]">
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {new Date(notify?.createdAt)?.toLocaleDateString("fa-IR")}
                  </p>
                </td>
                <td>
                  <p className="text-center text-[#575757] dark:text-light/80 text-sm">
                    {notify?.isRead ? (
                      <span className="text-success-400">خوانده شده</span>
                    ) : (
                      <span className="text-[#FF0000]">خوانده نشده</span>
                    )}
                  </p>
                </td>

                <td className="!max-w-[80px]">
                  <div className="flex flex-row gap-1 items-center">
                    <Button
                      className={`flex-center w-[70px] p-2.5 bg-secondary-default hover:bg-secondary-default/90  duration-150 text-white text-xs mx-auto rounded-md `}
                      onClick={() => {
                        setIsOpenShowModal(true);
                        setNotifyData(notify);
                      }}
                    >
                      مشاهده
                    </Button>
                    <Button
                      className={`flex-center  w-[70px] p-2.5 bg-primary-700 hover:bg-primary-700/90  duration-150 text-white text-xs mx-auto rounded-md `}
                      onClick={() => {
                        setIsOpenEditModal(true);
                        setNotifyData(notify);
                      }}
                    >
                      ویرایش
                    </Button>
                    <Button
                      className={`flex-center  w-[70px] p-2.5 bg-[#FF0000] hover:bg-[#FF0000]/80  duration-150 text-white text-xs mx-auto rounded-md `}
                      onClick={() => {
                        setIsOpenDeleteModal(true);
                        setNotifyId(notify?._id);
                      }}
                    >
                      حذف
                    </Button>
                  </div>
                </td>
              </tr>
            ))}
          </tbody>
        )}
      </table>
      {isOpenShowModal && (
        <ShowNotifyModal
          setIsOpenShowModal={setIsOpenShowModal}
          notifyData={notifyData}
        />
      )}
      {isOpenDeleteModal && (
        <DeleteModal
          notifyId={notifyId}
          setIsOpenDeleteModal={setIsOpenDeleteModal}
        />
      )}

      {isOpenEditModal && (
        <EditNotificationModal
          setIsOpenEditModal={setIsOpenEditModal}
          notifyData={notifyData}
        />
      )}
    </>
  );
}
