import { NotificationType } from "@/@types/notificaton";
import { Button } from "@/components/ui/button";
import React, { Dispatch, SetStateAction } from "react";

type ShowNotifyModalProps = {
  setIsOpenShowModal: Dispatch<SetStateAction<boolean>>;
  notifyData: null | NotificationType;
};

export default function ShowNotifyModal({
  setIsOpenShowModal,
  notifyData,
}: ShowNotifyModalProps) {
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-[screen] overflow-hidden animate-fadeIn z-50">
      <div className="w-[350px]  md:w-[600px] p-3 max-h-[90%] bg-light dark:bg-dark-400 rounded-10 z-50  overflow-y-auto">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            {notifyData?.title}
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[25%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[75%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div>
          <p className="font-peyda text-lg font-bold my-4 text-center">
            {notifyData?.description}
          </p>
        </div>
        <div className="flex items-center justify-center w-full gap-x-2 mt-[23px]">
          <Button
            className="hidden sm:inline-flex flex-center py-3 px-5 hover:bg-error-400  text-base text-error-400 hover:text-light border-error-400 rounded-10"
            variant={"outline"}
            onClick={() => setIsOpenShowModal(false)}
          >
            بستن
          </Button>
        </div>
      </div>
      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpenShowModal(false);
        }}
      ></div>
    </div>
  );
}
