"use client";
import { BlogType } from "@/@types/blog";
import { paginationType } from "@/@types/pagination";
import BlogCard from "@/components/modules/BlogCard";
import LoadingBox from "@/components/modules/LoadingBox";
import NotFoundDataBox from "@/components/modules/NotFoundDataBox";
import PaginationContainer from "@/components/modules/PaginationContainer";
import { defaultPage } from "@/lib/constants";
import { getBlogs } from "@/services/blog";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";

// type BlogGridProps = {
//   filter: FilterBlogType;
//   setFilter: Dispatch<SetStateAction<FilterBlogType>>;
// };

export default function BlogGrid() {
  const [paginationSize, setPaginationSize] =
    useState<paginationType>(defaultPage);

  // const router = useRouter();
  // const searchParams = useSearchParams();

  // const searchParamsText = buildSearchParams(filter, {
  //   page: paginationSize?.page,
  // });

  const { data: blogs, isLoading } = useQuery({
    queryKey: ["blogs"],
    queryFn: () => getBlogs(),
  });

  if (isLoading) return <LoadingBox />;
  return (
    <div className="w-full mb-20">
      {blogs?.data?.blogs?.length > 0 ? (
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-x-5 gap-y-3.75 my-3.5">
          {blogs?.data?.blogs?.map((blog: BlogType) => (
            <BlogCard key={blog._id} data={blog} />
          ))}
        </div>
      ) : (
        <div className="flex justify-center w-full lg:w-1/2 mx-auto">
          <NotFoundDataBox />
        </div>
      )}
      {blogs?.data?.files?.length > 0 && (
        <div className="w-full">
          <PaginationContainer
            page={paginationSize.page}
            setPage={setPaginationSize}
            totalPages={10}
          />
        </div>
      )}
    </div>
  );
}
