"use client";
import { FilterType } from "@/@types/filter";
import { paginationType } from "@/@types/pagination";
import { Slider } from "@/components/ui/Slider";
import { defaultFilterProducts } from "@/lib/constants";
import React, { Dispatch, SetStateAction, useEffect, useState } from "react";
import ShopAccordion from "../categoryName/ShopAccordion";
import SwitchItems from "../categoryName/SwitchItems";

type SubCategoryFilterProps = {
  filter: FilterType;
  setFilter: Dispatch<SetStateAction<FilterType>>;
  setPaginationSize: Dispatch<SetStateAction<paginationType>>;
};

export default function SubCategoryFilter({
  filter,
  setFilter,
  setPaginationSize,
}: SubCategoryFilterProps) {
  const [range, setRange] = useState<number[]>([
    Number(filter.minPrice) || 0,
    Number(filter.maxPrice) || 50_000_000,
  ]);

  useEffect(() => {
    if (range[0] === 0 && range[1] === 50_000_000) return;

    setFilter((prev) => ({
      ...prev,
      minPrice: String(range[0]),
      maxPrice: String(range[1]),
    }));
  }, [range]);

  useEffect(() => {
    setPaginationSize({ limit: 10, page: 1 });
  }, [filter]);

  const resetFilter = () => {
    setFilter({
      ...defaultFilterProducts,
      categoryid: filter?.categoryid,
      subcategoryid: filter?.subcategoryid,
    });
    setRange([0, 50_000_000]);
  };

  return (
    <div className="shrink-0 w-full lg:w-[24%] px-3.75 py-2.5 bg-light dark:bg-[#393939] rounded-15 border border-[#F2F2F2] dark:border-[#4E4E4E]">
      <div className="flex items-center justify-between pb-2 border-b border-dark/[7%] dark:border-light/10">
        <p className="text-sm text-[#A5A5A5]">فیلتر ها</p>
        <p
          className="text-secondary-default dark:text-light cursor-pointer"
          onClick={resetFilter}
        >
          حذف همه
        </p>
      </div>
      <div>
        <p className="py-3.5 text-dark dark:text-light text-sm font-medium">
          محدوده قیمت{" "}
        </p>
        <Slider
          value={range}
          onValueChange={setRange}
          max={50_000_000}
          step={100_000}
          className="my-3"
        />
        <div className="flex justify-between my-2 pb-3.25 text-xs font-medium text-dark dark:text-[#BEBEBE]  border-b border-dark/[7%] dark:border-light/10">
          <span>{range[1].toLocaleString("fa-IR")} تومان</span>
          <span>{range[0].toLocaleString("fa-IR")} تومان</span>
        </div>
      </div>
      <ShopAccordion />
      <SwitchItems filter={filter} setFilter={setFilter} />
    </div>
  );
}
