"use client";
import React, { useRef, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";

import "swiper/css";
import "swiper/css/pagination";

import "./../../../styles/swiperStyles.css";
import SwiperCore from "swiper";

import { Pagination } from "swiper/modules";
import ReviewsCard from "@/components/modules/ReviewsCard";
import { useQuery } from "@tanstack/react-query";
import { getComments } from "@/services/comment";

type CommentTye = {
  _id: string;
  text: string;
  userid: null;
  fileid: string;
  createdAt: string;
};

export const CustomerReviewsSlider = () => {
  const swiperRef = useRef<SwiperCore | null>(null);
  const [activeIndex, setActiveIndex] = useState(0);

  const handlePrev = () => swiperRef.current?.slidePrev();
  const handleNext = () => swiperRef.current?.slideNext();

  const { data: comments, isLoading } = useQuery({
    queryKey: ["comments"],
    queryFn: getComments,
    select: (res) => res.data,
  });

  return isLoading ? (
    <div className="flex items-center justify-center gap-6 p-5 w-full h-[372px] rounded-48 bg-neutral-150/20 animate-pulse">
      <div className="w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
      <div className="hidden xs:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
      <div className="hidden lg:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
      <div className="hidden xl:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
    </div>
  ) : (
    <>
      <Swiper
        loop={true}
        onSwiper={(swiper) => (swiperRef.current = swiper)}
        onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
        slidesPerView={1}
        spaceBetween={13}
        breakpoints={{
          640: { slidesPerView: 2, spaceBetween: 24 },
          768: { slidesPerView: 2, spaceBetween: 24 },
          1024: { slidesPerView: 3, spaceBetween: 19 },
        }}
        modules={[Pagination]}
        className="mySwiper rounded cursor-pointer"
      >
        {comments?.data?.map((comment: CommentTye) => (
          <SwiperSlide
            key={comment._id}
            className="flex flex-col items-start justify-start py-3.5 px-[17px] !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px] border border-[#E8E8E8] dark:border-[#616161]"
          >
            <ReviewsCard
              icon="prof2"
              name={comment?.fileid}
              text={comment?.text}
              date={comment?.createdAt}
            />
          </SwiperSlide>
        ))}
      </Swiper>

      {/* Navigation + Custom Pagination */}
      {comments?.data?.length > 3 && (
        <div className="flex items-center justify-center">
          <div className="mt-9 md:mr-[27px]">
            <div className="flex items-center gap-2">
              {/* Prev Button */}
              <div className="cursor-pointer" onClick={handlePrev}>
                <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-300 rounded-full">
                  <svg className="absolute -top-0.75 -right-3 size-9 text-dark-200 dark:text-light rotate-180">
                    <use href="#arrow-left"></use>
                  </svg>
                </span>
              </div>

              {/* Dots */}
              <div className="inline-block mb-2">
                {comments && (
                  <div className="flex justify-center items-center gap-2">
                    {comments?.data?.map((_: CommentTye, i: number) => (
                      <div
                        key={i}
                        className={`transition-all duration-300 rounded-full cursor-pointer ${
                          activeIndex === i
                            ? "bg-[#FFA700] w-[32px] dark:bg-[#FFF000] h-2"
                            : "bg-[#FFA700]/30 w-2 h-2"
                        }`}
                        onClick={() => swiperRef.current?.slideToLoop(i)}
                      />
                    ))}
                  </div>
                )}
              </div>

              {/* Next Button */}
              <div className="cursor-pointer" onClick={handleNext}>
                <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-300 rounded-full">
                  <svg className="absolute -top-0.75 right-1 size-9 text-dark-200 dark:text-light">
                    <use href="#arrow-left"></use>
                  </svg>
                </span>
              </div>
            </div>
          </div>
        </div>
      )}
    </>
  );
};
