import { Button } from "@/components/ui/button";
import Image from "next/image";
import { useRouter } from "next/navigation";
import React from "react";
import SearchInput from "./SearchInput";

const clickHandler = () => {
  window?.scrollBy({ top: 700, behavior: "smooth" });
};

export const HeroSection = () => {
  const router = useRouter();
  return (
    <section className="relative">
      <div className="w-full h-[400px] sm:h-139">
        <Image
          src="/images/baner.png"
          alt="عکس فروشگاه"
          width={1024}
          height={566}
          className="hidden dark:hidden sm:inline-block w-full h-full"
          quality={100}
        />
        <Image
          src="/images/baner-dark.png"
          alt="عکس فروشگاه دارک مود"
          width={1024}
          height={566}
          quality={100}
          className="hidden lg:dark:inline-block dark:inline-block w-full h-full"
        />
        <Image
          src="/images/baner-mobile.png"
          alt="بنر موبایل - لایت مود"
          width={1024}
          height={566}
          quality={100}
          className="inline-block sm:hidden dark:hidden w-full h-full"
        />

        {/* <Image
          src="/images/baner-dark-mobile.png"
          alt="بنر موبایل - دارک مود"
          width={1024}
          height={566}
          className="hidden sm:hidden dark:inline-block sm:dark:hidden w-full h-full"
        /> */}
        <div className="absolute top-[43px] sm:top-[120px] xl:top-28 w-full">
          <div className="flex flex-col sm:flex-row items-center justify-center gap-6 dark:gap-0 dark:sm:gap-6 xl:gap-7.25 w-full font-peyda font-bold text-xl ">
            <div className="w-[53px] sm:w-14 xl:w-18.25 h-[53px] sm:h-14 xl:h-19.75 shrink-0">
              <Image
                src="/images/heroLogo.svg"
                alt="عکس آیکون فروشگاه فایل و محصولات دیجیتال"
                width={73}
                height={79}
                quality={100}
                className="w-full h-full shrink-0"
              />
            </div>

            <p className="text-xl xs:text-3xl md:text-4xl lg:text-5.5xl xl:text-6.5xl font-peyda font-bold text-center text-nowrap">
              فروشگاه فایل و محصولات دیجیتال
            </p>
          </div>
          <p className="mt-2.25 mx-auto w-full text-center text-sm-mines sm:text-base md:text-lg lg:text-xl font-yekanbakh ">
            خرید و فروش محصولات دانلودی و غیر فیزیکی در کمترین زمان
          </p>
        </div>
        <svg
          className="dark:hidden hidden sm:inline-block absolute size-8 md:size-10 bottom-8 sm:bottom-16 lg:bottom-[76px] left-1/2 -translate-x-1/2 cursor-pointer"
          onClick={clickHandler}
        >
          <use href="#chevron-down2"></use>
        </svg>
        <svg
          className="hidden dark:sm:inline-block absolute size-8 md:size-10 bottom-8 sm:bottom-16 lg:bottom-[76px] left-1/2 -translate-x-1/2 cursor-pointer"
          onClick={clickHandler}
        >
          <use href="#chevron-down2-yellow"></use>
        </svg>
      </div>
      <div className="absolute top-[204px] sm:top-[250px] lg:top-[293px] flex flex-col md:flex-row items-center justify-center w-full mx-auto text-sm sm:text-base">
        <SearchInput />
        <div className="mr-1.75 mt-3.25 md:mt-0">
          <Button
            className="w-[250px] xs:w-[350px] sm:w-[400px] md:w-[80px] lg:w-[100px] xl:w-[191px] h-12 lg:h-[51px] bg-secondary-default hover:bg-secondary-default/90 dark:text-light rounded-9 lg:rounded-2xl"
            onClick={() => router?.push("/products")}
          >
            فروشگاه
          </Button>
        </div>
      </div>
    </section>
  );
};
