import { LatestBlogCard } from "@/components/modules/LatestBlogCard";
import { LatestBlogTitleBox } from "@/components/modules/LatestBlogTitleBox";
import { getBlogs } from "@/services/blog";
import { useQuery } from "@tanstack/react-query";

import Image from "next/image";
import Link from "next/link";
import React from "react";

export const LatestBlogs = () => {
  const { data: blogs, isLoading } = useQuery({
    queryKey: ["blogs"],
    queryFn: () => getBlogs(),
    select: (res) => res?.data?.blogs,
  });
  return (
    blogs &&
    blogs?.length > 0 && (
      <section className="bg-[#F9F9F9] dark:bg-dark-300 pt-[71px] pb-[106px] md:px-[108px]">
        <h3 className="font-peyda font-bold text-4x-mines text-center">
          آخرین مقالات
        </h3>
        {isLoading ? (
          <div className="md:container flex flex-wrap items-center justify-center gap-6 p-5 mt-8 w-full rounded-48 bg-neutral-150/20 animate-pulse !shrink-0">
            <div>
              <div className="w-[300px] md:w-[392px] h-[182px] mb-2 rounded-48 bg-neutral-100/20"></div>
              <div className="w-[300px] md:w-[392px] h-[182px] rounded-48 bg-neutral-100/20"></div>
            </div>
            <div className=" w-[300px] md:w-[392px] h-[380px] rounded-48 bg-neutral-100/20"></div>
            <div className="space-y-2">
              <div className="w-[300px] md:w-[392px] h-20 rounded-48 bg-neutral-100/20"></div>
              <div className="w-[300px] md:w-[392px] h-20 rounded-48 bg-neutral-100/20"></div>
              <div className="w-[300px] md:w-[392px] h-20 rounded-48 bg-neutral-100/20"></div>
              <div className="w-[300px] md:w-[392px] h-20 rounded-48 bg-neutral-100/20"></div>
            </div>
          </div>
        ) : (
          <div className="flex flex-wrap items-start justify-center gap-6 mt-8 px-5 ">
            <div>
              <LatestBlogCard blogData={blogs?.length >= 1 ? blogs[1] : null} />
              <LatestBlogCard blogData={blogs?.length >= 2 ? blogs[2] : null} />
            </div>
            <div className="w-[350px] md:w-[392px] h-[380px] md:h-[380px] rounded-48 overflow-hidden shrink-0">
              {blogs[0] && (
                <Link
                  className="relative w-full h-full"
                  href={`/blogs/${blogs[0]?.href}`}
                >
                  <Image
                    src={`${process.env.NEXT_PUBLIC_BASE_URL}${blogs[0]?.img}`}
                    width={392}
                    height={380}
                    alt="عکس بلاگ"
                    className="w-full h-full object-cover"
                  />
                  <Image
                    src={"/images/img-bg.png"}
                    alt="bg-bluer"
                    width={392}
                    height={380}
                    className="absolute bottom-0 left-0 w-full h-full"
                  />
                  <div className="absolute bottom-0 left-0 flex items-center justify-between w-full text-light  z-40">
                    <div className="mb-[37px] mr-5">
                      <p className="font-peyda font-bold text-xl line-clamp-1">
                        {blogs[0]?.title}
                      </p>
                      <div className="flex items-center gap-1 text-light">
                        <svg className="size-5 !text-light">
                          <use href="#clock"></use>
                        </svg>
                        <p className="mt-1 font-medium text-base">
                          زمان مطالعه : 5 دقیقه
                        </p>
                      </div>
                    </div>
                    <div className="flex-center mb-[37px] ml-5 rounded-full size-[50px] border-2 border-light-200 shrink-0">
                      <svg className="size-7 shrink-0">
                        <use href="#arrow"></use>
                      </svg>
                    </div>
                  </div>
                </Link>
              )}
            </div>
            <div className="flex flex-col items-center justify-center gap-5">
              <LatestBlogTitleBox
                blogData={blogs?.length >= 3 ? blogs[3] : null}
              />
              <LatestBlogTitleBox
                blogData={blogs?.length >= 4 ? blogs[4] : null}
              />
              <LatestBlogTitleBox
                blogData={blogs?.length >= 5 ? blogs[5] : null}
              />
              <LatestBlogTitleBox
                blogData={blogs?.length >= 6 ? blogs[6] : null}
              />
            </div>
          </div>
        )}
      </section>
    )
  );
};
