"use client";
import React, { useRef, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";

import "swiper/css";
import "swiper/css/pagination";

import "./../../../styles/swiperStyles.css";

import { Pagination } from "swiper/modules";
import ShopCard from "@/components/modules/ShopCard";
import SwiperCore from "swiper";
import { useQuery } from "@tanstack/react-query";
import { getLatestProducts } from "@/services/produts";
import { file } from "@/@types/file";

export default function LatestProductsSwiper() {
  const { data: products, isLoading } = useQuery({
    queryKey: ["latest-products"],
    queryFn: getLatestProducts,
    select: (res) => res.data.files,
  });

  const swiperRef = useRef<SwiperCore>();
  const [activeIndex, setActiveIndex] = useState(0);

  const handlePrev = () => swiperRef.current?.slidePrev();
  const handleNext = () => swiperRef.current?.slideNext();

  return (
    <>
      {isLoading ? (
        <div className="flex items-center justify-center gap-6 p-5 w-full h-[372px] rounded-48 bg-neutral-150/20 animate-pulse">
          <div className="w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden xs:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden lg:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden xl:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
        </div>
      ) : (
        <>
          <Swiper
            onSwiper={(swiper) => (swiperRef.current = swiper)}
            onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
            slidesPerView={1}
            spaceBetween={33}
            breakpoints={{
              0: {
                slidesPerView: 2,
                spaceBetween: 24,
                centeredSlides: true,
              },
              768: {
                slidesPerView: 3,
                spaceBetween: 24,
              },
              1024: {
                slidesPerView: 3,
                spaceBetween: 24,
              },
              1280: {
                slidesPerView: 4,
                spaceBetween: 20,
              },
            }}
            modules={[Pagination]}
            loop={true}
            className="mySwiper !py-2 !pr-6 lg:!pr-5 !bg-[#ffffff] dark:!bg-dark-200 !rounded-10 cursor-pointer !overflow-hidden"
          >
            {products?.map((product: file) => (
              <SwiperSlide
                key={product._id}
                className="flex flex-col items-start justify-start !w-[268px] sm:!w-[288px] !h-[318px] sm:!h-[372px] px-6 !bg-light dark:!bg-dark-500 rounded-48 shadow-[0_8px_64px_rgba(41,65,115,0.04)]"
              >
                <ShopCard productData={product} />
              </SwiperSlide>
            ))}
          </Swiper>
        </>
      )}

      {products?.length > 3 && (
        <div className="flex items-center justify-center md:justify-between">
          <div className="mt-9 md:mr-[27px]">
            <div className="flex items-center gap-2">
              <div className="cursor-pointer" onClick={handlePrev}>
                <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
                  <svg className="absolute -top-0.75 -right-3 size-9 text-dark-200 dark:text-light rotate-180">
                    <use href="#arrow-left"></use>
                  </svg>
                </span>
              </div>
              {/* pagination */}
              <div className="inline-block md:hidden mb-2">
                {products && (
                  <div className="flex justify-center items-center gap-2">
                    {products.map((_: file, i: number) => (
                      <div
                        key={i}
                        className={`transition-all duration-300 rounded-full cursor-pointer ${
                          activeIndex === i
                            ? "bg-[#081035] w-[32px] dark:bg-[#FFF000] h-2"
                            : "bg-[#ECEDF4]  w-2 h-2"
                        }`}
                        onClick={() => swiperRef.current?.slideToLoop(i)}
                      />
                    ))}
                  </div>
                )}
              </div>
              <div className="cursor-pointer" onClick={handleNext}>
                <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
                  <svg className="absolute -top-0.75 right-1 size-9 text-dark-200 dark:text-light">
                    <use href="#arrow-left"></use>
                  </svg>
                </span>
              </div>
            </div>
          </div>
          <div className="hidden md:inline-block">
            {products && (
              <div className="flex justify-center items-center gap-2 mt-6">
                {products.map((_: file, i: number) => (
                  <div
                    key={i}
                    className={`transition-all duration-300 rounded-full cursor-pointer ${
                      activeIndex === i
                        ? "bg-[#081035] dark:!bg-[#FFF000] w-[32px] h-2"
                        : "bg-[#ECEDF4] w-2 h-2"
                    }`}
                    onClick={() => swiperRef.current?.slideToLoop(i)}
                  />
                ))}
              </div>
            )}
          </div>
        </div>
      )}
    </>
  );
}
