"use client";
import CustomToast from "@/components/modules/CustomToast";
import { Button } from "@/components/ui/button";
import { useRouter } from "next/navigation";
import React, { useState } from "react";

export default function SearchInput() {
  const [value, setValue] = useState<string>("");
  const router = useRouter();
  const searchHandler = () => {
    if (value?.trim().length < 3) {
      return CustomToast({
        text: "برای جستجو، حداقل 3 حرف وارد کنید",
        type: "warning",
      });
    }

    router?.push(`/products/s?query=${value}`);
  };
  return (
    <div className="flex w-[250px] xs:w-[354px] sm:w-[400px] lg:w-[500px] xl:w-[625px] h-[54px] lg:h-16 bg-light dark:bg-dark-500 overflow-hidden rounded-20 border border-light-450 dark:border-neutral-500/40">
      <input
        className="w-full h-full pr-[15px] lg:pr-[29px] bg-inherit text-[#919191] outline-none"
        type="text"
        placeholder="به دنبال چه چیزی میگردی  ..."
        value={value}
        onChange={(e) => setValue(e.target?.value)}
      />
      <Button
        className="ml-2.5 my-2 size-[38px] lg:size-[47px] dark:bg-dark dark:hover:bg-dark/60 rounded-15 shrink-0"
        onClick={searchHandler}
      >
        <svg className="size-[13px]">
          <use href="#magnifying"></use>
        </svg>
      </Button>
    </div>
  );
}
