import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { getProduct } from "@/services/produts";
import { useQuery } from "@tanstack/react-query";
import Image from "next/image";
import Link from "next/link";
import React, { Dispatch, SetStateAction } from "react";

type OrderModalProps = {
  setIsOpenOrderModal: Dispatch<SetStateAction<boolean>>;
  productUid: string;
  productName: string;
};

export default function OrderModal({
  setIsOpenOrderModal,
  productUid,
  productName,
}: OrderModalProps) {
  const { data: product, isLoading } = useQuery({
    queryKey: ["get-product", productName, productUid],
    queryFn: () => getProduct({ title: productName, id: productUid }),
    select: (res) => res.data?.files,
  });

  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-50">
      <div className="w-[350px] md:w-[400px]w-[350px] md:w-[600px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <div className="flex items-center gap-1">
            <svg className="size-5 text-success-400">
              <use href="#check-circle-solid"></use>
            </svg>
            <p className="font-bold text-sm md:text-xl text-[#001A46] dark:text-light">
              محصول با موفقیت به سبد خرید شما اضافه شد
            </p>
          </div>
          <div className="flex items-center mt-4">
            <span className="w-[25%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[75%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div>
          {isLoading ? (
            <LoadingBox />
          ) : (
            <div className="flex items-center justify-between gap-1 w-full p-2 md:p-5">
              <div className="flex items-center gap-1">
                <div className="size-20 rounded-9 overflow-hidden">
                  <Image
                    src={`${process.env.NEXT_PUBLIC_BASE_URL}${product?.images[0]}`}
                    width={80}
                    height={80}
                    className="w-full h-full"
                    alt={product?.title}
                  />
                </div>
                <p className="text-sm line-clamp-2">{product?.title}</p>
              </div>
              <p className="text-sm">
                {product?.price?.toLocaleString()} تومان
              </p>
            </div>
          )}
          <div className="flex items-center justify-center w-full gap-x-2 mt-[23px]">
            <Link
              href={"/orders"}
              className="hidden sm:inline-flex flex-center gap-1 py-3.5 px-5 bg-secondary-default hover:bg-secondary-default/90 text-sm md:text-base text-light rounded-10"
            >
              <svg className="size-5">
                <use href="#shop"></use>
              </svg>
              <span>رفتن به سبد خرید</span>
            </Link>
            <Button
              className="hidden sm:inline-flex flex-center py-6 px-5  hover:bg-error-400/90 text-sm md:text-base text-error-400 hover:text-light border border-error-400 rounded-10"
              onClick={() => setIsOpenOrderModal(false)}
              variant={"outline"}
            >
              ادامه خرید
            </Button>
          </div>
        </div>
        <div
          className="absolute w-full h-full z-40"
          onClick={() => {
            setIsOpenOrderModal(false);
          }}
        ></div>
      </div>
    </div>
  );
}
