import React from "react";
import DOMPurify from "dompurify";

export default function ProductContent({ data }: { data: string }) {
  const cleanText = DOMPurify.sanitize(data, { USE_PROFILES: { html: true } });

  return (
    <section className="w-full px-9 py-[28px] mt-3.75 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-3.75">
        <div className="flex flex-col">
          <span className="inline-block w-1 h-3.5 rounded-full bg-secondary-default"></span>
          <span className="inline-block w-1 h-[23px] rounded-full bg-primary-200"></span>
        </div>
        <p className="dark:text-light font-peyda font-bold text-xl">
          معرفی محصول
        </p>
      </div>
      <div className="mt-11 w-full">
        <div
          className="blog-content w-full text-[#8D8D8D] dark:text-[#CFCFCF] font-medium text-sm lg:text-lg text-justify leading-8"
          dangerouslySetInnerHTML={{ __html: cleanText }}
        ></div>
      </div>
    </section>
  );
}
