"use client";
import React, { RefObject, useRef, useState } from "react";
import ProductInfoHeader from "./ProductInfoHeader";
import ProductContent from "./ProductContent";

import ProductComments from "./ProductComments";
import CommentAnswerForm from "./CommentAnswerForm";
import SimilarProducts from "./SimilarProducts";
import ProductDetails from "./ProductDetails";
import { file } from "@/@types/file";
import { CommentsType } from "@/@types/comment";

type ProductInfoProps = {
  data: file;
  comments: CommentsType;
  keyValue: string[];
  buyProductRef: RefObject<HTMLDivElement>;
};

export default function ProductInfo({
  data,
  comments,
  keyValue,
  buyProductRef,
}: ProductInfoProps) {
  const [commentId, setCommentId] = useState<string>("");
  const answerFormRef = useRef<HTMLFormElement | null>(null);
  const handleReply = (id: string) => {
    setCommentId(id);
    if (answerFormRef.current) {
      answerFormRef.current.scrollIntoView({
        behavior: "smooth",
        block: "center",
      });
    }
  };
  return (
    <div className="flex flex-col-reverse lg:flex-row items-start gap-y-[27px] mt-[34px]">
      <section className="w-full lg:w-[65%] shrink-0">
        <ProductInfoHeader />
        <ProductContent data={data?.decs} />
        <ProductComments commentsData={comments} onReply={handleReply} />
        <CommentAnswerForm
          productId={data?._id}
          keyValue={keyValue}
          textareaRef={answerFormRef}
          commentId={commentId}
        />
      </section>
      <section className="w-full lg:w-[35%] lg:mr-[23px]">
        <ProductDetails
          price={data?.price}
          features={data?.features}
          customOptions={data?.customOptions}
          productId={data?._id}
          buyProductRef={buyProductRef}
          userName={data?.userid?.username || ""}
          salesCount={data?.salesCount}
          productUid={data?.uid}
          productName={data?.title}
        />
        <SimilarProducts id={data?.categoryid} />
      </section>
    </div>
  );
}
