"use client";
import { file } from "@/@types/file";
import { paginationType } from "@/@types/pagination";
import LoadingBox from "@/components/modules/LoadingBox";
import NotFoundDataBox from "@/components/modules/NotFoundDataBox";
import PaginationContainer from "@/components/modules/PaginationContainer";
import ProductCard from "@/components/modules/ProductCard";
import { defaultPage } from "@/lib/constants";
import { getSearchProducts } from "@/services/produts";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";

export default function ProductsSearchGrid({ query }: { query: string }) {
  const [paginationSize, setPaginationSize] =
    useState<paginationType>(defaultPage);
  const { data: products, isLoading } = useQuery({
    queryKey: [query],
    queryFn: () => getSearchProducts(query ?? ""),
  });
  if (isLoading) return <LoadingBox />;

  return (
    <div className="w-full lg:w-[76%]">
      {products?.data?.files?.length > 0 ? (
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-x-5 gap-y-3.75 my-3.5">
          {products?.data?.files?.map((file: file) => (
            <ProductCard key={file._id} data={file} />
          ))}
        </div>
      ) : (
        <NotFoundDataBox />
      )}
      {products?.data?.files?.length > 0 && (
        <div className="w-full">
          <PaginationContainer
            page={paginationSize.page}
            setPage={setPaginationSize}
            totalPages={10}
          />
        </div>
      )}
    </div>
  );
}
