import { Button } from "@/components/ui/button";
import Image from "next/image";
import React from "react";

export default function HeroSection() {
  return (
    <section className="mt-20 mb-3.75">
      <div className=" relative w-[360px] md:w-full h-[293px] md:h-auto lg:h-[343px] mx-auto">
        <Image
          src="/images/bg-products-cover.png"
          alt="عکس بک گراند صفحه محصولات"
          width={1200}
          height={343}
          className="hidden md:inline-block dark:hidden w-full h-full"
        />
        <Image
          src="/images/bg-products-cover-dark.png"
          alt="عکس بک گراند صفحه محصولات"
          width={1200}
          height={343}
          className="hidden dark:md:inline-block w-full h-full"
        />
        <Image
          src="/images/bg-products-cover-mobile.png"
          alt="عکس بک گراند صفحه محصولات"
          width={1200}
          height={343}
          className="block md:hidden dark:hidden w-full h-full"
        />
        <Image
          src="/images/bg-products-cover-dark-mobile.png"
          alt="عکس بک گراند صفحه محصولات"
          width={1200}
          height={343}
          className="hidden dark:block md:dark:hidden w-full h-full"
        />

        <div className="absolute top-4 right-[25px] md:right-[37px] flex items-center gap-1 lg:gap-[18px] child:text-light">
          <svg className="size-4">
            <use href="#circle-outline"></use>
          </svg>
          <p className="text-base-mines lg:text-xl">فروشگاه</p>
        </div>
        <p className="absolute top-[46px] right-[25px] md:right-[37px] mt-1 font-extrabold text-xl lg:text-4xl text-light">
          دارکوفایل
        </p>
        <p className="absolute top-[80px] lg:top-[110px] right-[25px] md:right-[37px] max-w-[230px] md:max-w-[420px] lg:max-w-[607px] mt-1 text-base text-light lg:leading-9">
          لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده
          از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و
          سطرآنچنان که لازم است{" "}
        </p>
        <Button className="absolute top-[230px] md:top-[160px] lg:top-[230px] right-[25px] md:right-[37px] flex items-center gap-3.25 h-[40px] lg:h-[55px] max-w-[607px] mt-1 px-3.75 bg-light dark:bg-primary-200 hover:bg-light/90 text-sm lg:text-base text-secondary-default dark:text-dark  duration-150 rounded-15">
          <p className="font-bold">بیشتر بخوانید</p>
          <svg className="!size-5 lg:!size-7 shrink-0">
            <use href="#arrow-circle"></use>
          </svg>
        </Button>
      </div>
    </section>
  );
}
