import { getMembershipDuration } from "@/lib/utils";
import Image from "next/image";
import React from "react";

type ProductInfoProps = {
  date: string;
  totalSellMoney: number;
  totalSellCount: number;
  amazingProductCount: number;
};

export default function ProductInfo({
  date,
  totalSellMoney,
  totalSellCount,
  amazingProductCount,
}: ProductInfoProps) {
  return (
    <div className="px-4 py-3.5 my-1.75 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg divide-y divide-[#F3F3F3] dark:divide-[#4E4E4E]">
      <div className="flex items-center justify-between pt-2.75 pb-1.75">
        <div className="flex items-center gap-2.25">
          <Image
            src="/images/date.png"
            alt="زمان عضویت"
            width={29}
            height={29}
            className="size-[29px]"
          />
          <p className="text-sm-mines font-medium text-[#8F8F8F] dark:text-[#C8C8C8]">
            زمان عضویت :
          </p>
        </div>
        <p className="text-sm-mines dark:text-light">
          {getMembershipDuration(date)}
        </p>
      </div>
      <div className="flex items-center justify-between pt-2.75 pb-1.75">
        <div className="flex items-center gap-2.25">
          <Image
            src="/images/setting.png"
            alt="فروش"
            width={29}
            height={29}
            className="size-[29px]"
          />
          <p className="text-sm-mines font-medium text-[#8F8F8F] dark:text-[#C8C8C8]">
            فروش :
          </p>
        </div>
        <p className="text-sm-mines dark:text-light">
          {totalSellMoney?.toLocaleString()} تومان
        </p>
      </div>
      <div className="flex items-center justify-between pt-2.75 pb-1.75">
        <div className="flex items-center gap-2.25">
          <Image
            src="/images/shop.png"
            alt="تعداد فروش"
            width={29}
            height={29}
            className="size-[29px]"
          />
          <p className="text-sm-mines font-medium text-[#8F8F8F] dark:text-[#C8C8C8]">
            تعداد فروش :
          </p>
        </div>
        <p className="text-sm-mines dark:text-light">{totalSellCount}</p>
      </div>
      <div className="flex items-center justify-between pt-2.75 pb-1.75">
        <div className="flex items-center gap-2.25">
          <Image
            src="/images/tick.png"
            alt="محصول ویژه :"
            width={29}
            height={29}
            className="size-[29px]"
          />
          <p className="text-sm-mines font-medium text-[#8F8F8F] dark:text-[#C8C8C8]">
            محصول ویژه :
          </p>
        </div>
        <p className="text-sm-mines dark:text-light">
          دارای {amazingProductCount} محصول ویژه
        </p>
      </div>
    </div>
  );
}
