"use client";
import React from "react";
import ProductsGrid from "./ProductsGrid";
import ProductDetails from "./ProductDetails";
import LoadingBox from "@/components/modules/LoadingBox";
import { useQuery } from "@tanstack/react-query";
import { getShop } from "@/services/store";

export default function ProductsBox({ userName }: { userName: string }) {
  const { data: shopData, isLoading } = useQuery({
    queryKey: ["admin-banks"],
    queryFn: () => getShop(userName),
    select: (res) => res.data,
  });
  if (isLoading) return <LoadingBox />;
  return (
    <section className="flex flex-col-reverse lg:flex-row items-start gap-3.75">
      <ProductsGrid products={shopData?.products} paging={shopData?.paging} />
      <ProductDetails
        userInfo={shopData?.userInfo}
        bestProducts={shopData?.bestProducts}
      />
    </section>
  );
}
