"use client";
import React, { useState } from "react";
import ProductsHeader from "./ProductsHeader";
import ProductCard from "@/components/modules/ProductCard";
import PaginationContainer from "@/components/modules/PaginationContainer";
import { paginationType } from "@/@types/pagination";
import { defaultPage } from "@/lib/constants";
import { file } from "@/@types/file";
import NotFoundDataBox from "@/components/modules/NotFoundDataBox";

type pagingType = {
  page: number;
  perPage: number;
  totalProducts: number;
  totalPages: number;
};

export default function ProductsGrid({
  products,
  paging,
}: {
  products: file[];
  paging: pagingType;
}) {
  const [paginationSize, setPaginationSize] =
    useState<paginationType>(defaultPage);
  return (
    <div className="w-full lg:w-[76%]">
      <ProductsHeader />
      <>
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-x-5 gap-y-3.75 my-3.5">
          {products ? (
            products?.map((product: file) => (
              <ProductCard key={product?._id} data={product} />
            ))
          ) : (
            <div className="col-span-12">
              <NotFoundDataBox />
            </div>
          )}
        </div>
        <div className="w-full">
          <PaginationContainer
            page={paginationSize.page}
            setPage={setPaginationSize}
            totalPages={paging?.totalPages}
          />
        </div>
      </>
    </div>
  );
}
