"use client";
import { BlogType } from "@/@types/blog";
import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { getAuthBlogs } from "@/services/blog";
import { useQuery } from "@tanstack/react-query";
import Image from "next/image";
import { useRouter } from "next/navigation";
import React, { useState } from "react";
import DeleteModal from "./DeleteModal";

export default function BlogsTable() {
  const router = useRouter();

  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [blogId, setBlogId] = useState<string>("");

  const { data, isLoading } = useQuery({
    queryKey: ["user-auth-blogs"],
    queryFn: getAuthBlogs,
    select: (res) => res.data,
  });

  if (isLoading) return <LoadingBox />;

  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className=" child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 border-b border-dark/[7%] dark:border-light/[6%]">
              نام
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ ایجاد
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              تاریخ ویرایش
            </th>

            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              مشاهده / ویرایش
            </th>
          </tr>
        </thead>
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {data?.blogs?.map((blog: BlogType) => (
            <tr
              key={blog._id}
              className=" child:py-[30px] child:px-2  child:min-w-[150px] lg:child:w-[15%]"
            >
              <td>
                <div className="flex items-center gap-2 xl:gap-[18px]">
                  <Image
                    src={`${process.env.NEXT_PUBLIC_BASE_URL}${blog?.img}`}
                    width={80}
                    height={80}
                    alt={blog?.title}
                  />
                  <p className="text-[#575757] font-bold text-center dark:text-light/80 text-sm line-clamp-1">
                    {blog?.title}
                  </p>
                </div>
              </td>
              <td>
                <p className="text-[#575757] dark:text-light/80 text-base text-center">
                  {new Date(blog?.createdAt)?.toLocaleDateString("fa-IR")}
                </p>
              </td>
              <td>
                <p className="text-[#575757] dark:text-light/80 text-base text-center">
                  {blog?.date}
                </p>
              </td>
              <td className="">
                <Button
                  className={`flex-center p-2.5 duration-150 text-white text-xs mx-auto rounded-md bg-error-400 hover:bg-error/90`}
                  onClick={() => {
                    setIsOpenDeleteModal(true);
                    setBlogId(blog?._id);
                  }}
                >
                  حذف
                </Button>
              </td>
              <td className="">
                <Button
                  className={`flex-center p-2.5 duration-150 text-white text-xs mx-auto rounded-md bg-secondary-default hover:bg-secondary-default/90`}
                  onClick={() => {
                    router.push(`/user-panel/blogs/${blog?._id}`);
                  }}
                >
                  مشاهده
                </Button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>
      {isOpenDeleteModal && (
        <DeleteModal setIsOpenDeleteModal={setIsOpenDeleteModal} id={blogId} />
      )}
    </>
  );
}
