"use client";
import { DownloadType } from "@/@types/download";
import { Button } from "@/components/ui/button";
import React, { useState } from "react";
import DownloadDetailsModal from "./DownloadDetailsModal";

export default function DownloadsTable({
  downloadData,
}: {
  downloadData: DownloadType[];
}) {
  const [isOpen, setIsOpen] = useState<boolean>(false);
  const [data, setData] = useState<DownloadType | null>(null);
  const clickHandler = (data: DownloadType) => {
    setData(data);
    setIsOpen(true);
  };
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-center child:text-[#A5A5A5] child:text-sm">
            <th>شناسه</th>
            <th>شرح تراکنش</th>
            <th>تاریخ خرید</th>
            <th>مبلغ</th>
            <th>عملیات</th>
          </tr>
        </thead>
        {downloadData?.length > 0 ? (
          <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
            {downloadData?.map((item: DownloadType) => (
              <tr
                className=" child:py-[30px] child:px-2 child:text-center child:grow child:min-w-[200px] lg:child:w-[20%]"
                key={item?._id}
              >
                <td>
                  <p className="text-base xl:text-lg text-center">
                    #{item?.uid}
                  </p>
                </td>
                <td>
                  <p className="font-bold text-base xl:text-lg text-center">
                    {item?.products?.length > 0
                      ? "چندین محصول"
                      : item?.products[0]?.productID?.title}
                  </p>
                </td>
                <td className="text-wrap whitespace-normal text-[#1D1C1A] dark:text-light">
                  <p className="text-center text-base">
                    {new Date(item?.updatedAt)?.toLocaleDateString("fa-IR")}
                  </p>
                </td>
                <td className="">
                  <p className="text-[#858585] dark:text-light/80 font-medium text-sm">
                    {item?.price?.toLocaleString()} تومان
                  </p>
                </td>
                <td>
                  <Button
                    className="flex-center w-full h-[48px] px-5 mx-auto bg-secondary-default hover:bg-secondary-default/90 text-base dark:text-light rounded"
                    onClick={() => clickHandler(item)}
                  >
                    دانلود
                  </Button>
                </td>
              </tr>
            ))}
          </tbody>
        ) : (
          <tbody>
            <tr>
              <td colSpan={4} className="text-center py-10 text-[#EE404C]">
                دیتایی یافت نشد
              </td>
            </tr>
          </tbody>
        )}
      </table>
      {isOpen && (
        <DownloadDetailsModal
          isOpen={isOpen}
          setIsOpen={setIsOpen}
          data={data}
        />
      )}
    </>
  );
}
