"use client";
import { orderType } from "@/@types/order";
import LoadingBox from "@/components/modules/LoadingBox";

import React from "react";

type OrdersTableProps = {
  isLoading: boolean;
  orders: orderType[] | null;
};

export default function OrdersTable({ isLoading, orders }: OrdersTableProps) {
  if (isLoading) return <LoadingBox />;
  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-center child:text-[#A5A5A5] child:text-sm">
          <th>شماره سفارش</th>
          {/* <th>وضعیت</th> */}
          <th>تاریخ</th>
          <th>ملبغ</th>
          {/* <th>عملیات</th> */}
        </tr>
      </thead>
      {orders ? (
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {orders?.map((order: orderType) => (
            <tr
              key={order?._id}
              className=" child:py-[30px] child:px-2 child:text-center child:grow child:min-w-[200px] lg:child:w-[20%]"
            >
              <td>
                <p className="font-medium text-[#17183B] dark:text-light text-sm xl:text-lg text-center">
                  #{order?.uid}
                </p>
              </td>
              {/* <td className="flex-center gap-2.75  child:text-[#00B074]">
                <svg className="size-5 shrink-0">
                  <use href="#done"></use>
                </svg>
                <p className="font-medium text-sm">تکمیل شده</p>
              </td> */}
              <td className="text-wrap whitespace-normal text-[#1D1C1A] dark:text-light">
                <p className="font-medium text-center text-base">
                  {new Date(order?.updatedAt)?.toLocaleDateString("fa-ir")}
                </p>
              </td>

              <td>
                <div className="flex items-center justify-center gap-1.75 text-[#081035] dark:text-light">
                  <p className="font-peyda font-extrabold text-base xl:text-lg text-center">
                    {order?.price?.toLocaleString()}
                  </p>
                  <p className="font-peyda font-medium text-base xl:text-base text-center">
                    تومان
                  </p>
                </div>
              </td>
              {/* <td>
                <Button className="flex-center w-full h-[48px] px-5 mx-auto bg-secondary-default hover:bg-secondary-default/90 text-base dark:text-light rounded">
                  مشاهده
                </Button>
              </td> */}
            </tr>
          ))}
        </tbody>
      ) : (
        <tbody>
          <tr>
            <td colSpan={4} className="text-center py-10 text-[#EE404C]">
              دیتایی یافت نشد
            </td>
          </tr>
        </tbody>
      )}
    </table>
  );
}
